/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.silverpeas.core.admin.component.GroupOfParametersSorter;
import org.silverpeas.core.admin.component.model.GroupOfParameters;
import org.silverpeas.core.admin.component.model.LocalizedComponent;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.ParameterSorter;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MemoizedSupplier;

public abstract class AbstractSilverpeasComponent
implements SilverpeasComponent {
    @XmlTransient
    protected Map<String, Parameter> indexedParametersByName = new HashMap<String, Parameter>();
    @XmlTransient
    private final MemoizedSupplier<Map<String, LocalizedComponent>> localized = new MemoizedSupplier(HashMap::new);

    private LocalizedComponent getLocalized(String lang) {
        return ((Map)this.localized.get()).computeIfAbsent(lang, l -> new LocalizedComponent(this, (String)l));
    }

    protected abstract Map<String, String> getLabel();

    @Override
    public String getLabel(String lang) {
        return this.getLocalized(lang).getLabel();
    }

    protected abstract Map<String, String> getDescription();

    @Override
    public String getDescription(String lang) {
        return this.getLocalized(lang).getDescription();
    }

    protected Map<String, Parameter> getIndexedParametersByName() {
        List<Parameter> definedParameters = this.getParameters();
        if (CollectionUtil.isNotEmpty(definedParameters) && definedParameters.size() != this.indexedParametersByName.size()) {
            for (Parameter parameter : definedParameters) {
                this.indexedParametersByName.put(parameter.getName(), parameter);
            }
        }
        List<GroupOfParameters> theGroupsOfParameters = this.getGroupsOfParameters();
        for (GroupOfParameters group : theGroupsOfParameters) {
            for (Parameter parameter : group.getParameters()) {
                this.indexedParametersByName.put(parameter.getName(), parameter);
            }
        }
        return this.indexedParametersByName;
    }

    @Override
    public List<Parameter> getSortedParameters() {
        this.getParameters().sort(new ParameterSorter());
        return this.getParameters();
    }

    @Override
    public List<GroupOfParameters> getSortedGroupsOfParameters() {
        this.getGroupsOfParameters().sort(new GroupOfParametersSorter());
        return this.getGroupsOfParameters();
    }
}

