/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.dao.CommonDAO;
import org.silverpeas.core.admin.component.dao.ComponentInstLightSorter;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.kernel.util.StringUtil;

public class ComponentDAO
extends CommonDAO {
    private static final String INSTANCE_COLUMNS = "id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked";
    private static final String WHERE_INSTANCE_ID_MATCHES = " where c.id=r.instanceId";
    private static final String AND_COMPONENT_STATUS_IS_NULL = " and c.componentstatus is null";
    private static final String AND_OBJECT_ID_IS_NULL = " and r.objectId is null";
    private static final String QUERY_ALL_SPACE_INSTANCE_IDS = "select id, componentName from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String QUERY_ALL_SPACE_INSTANCES = "SELECT id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked FROM ST_ComponentInstance WHERE spaceId = ? AND componentStatus IS NULL ORDER BY orderNum";
    private static final String QUERY_ALL_AVAILABLE_COMPONENT_IDS = " SELECT DISTINCT(c.id), c.componentName FROM st_componentinstance c, st_userrole r, st_userrole_user_rel ur where c.id=r.instanceId and c.componentstatus is null AND r.id=ur.userroleid and r.objectId is null AND ur.userId = ? ";
    private static final String QUERY_ALL_PUBLIC_COMPONENT_IDS = " SELECT c.id, c.componentName FROM st_componentinstance c WHERE c.ispublic=1 and c.componentstatus is null";
    private static final String QUERY_PUBLIC_COMPONENT_IDS_IN_SPACE = " select c.id, c.componentName, c.ordernum from st_componentinstance c where c.ispublic=1 and c.spaceId = ? and c.componentstatus is null";
    private static final int COMPONENT_ID_COLUMN = 1;
    private static final int COMPONENT_NAME_COLUMN = 2;
    private static final int COMPONENT_ORDER_COLUMN = 3;

    private ComponentDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getComponentIdsInSpace(Connection con, int spaceId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(QUERY_ALL_SPACE_INSTANCE_IDS);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(2) + rs.getInt(1));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    private static ComponentInstLight fetchComponentInstance(ResultSet rs) throws SQLException {
        ComponentInstanceRow row = new ComponentInstanceRow();
        row.id = rs.getInt("id");
        row.spaceId = rs.getInt("spaceId");
        row.name = rs.getString("name");
        row.componentName = rs.getString("componentName");
        row.description = rs.getString("description");
        row.inheritanceBlocked = rs.getInt("isInheritanceBlocked");
        row.hidden = rs.getInt("isHidden");
        row.createdBy = rs.getInt("createdBy");
        row.orderNum = rs.getInt("orderNum");
        row.createTime = rs.getString("createTime");
        row.updateTime = rs.getString("updateTime");
        row.removeTime = rs.getString("removeTime");
        row.status = rs.getString("componentStatus");
        row.updatedBy = rs.getInt("updatedBy");
        row.removedBy = rs.getInt("removedBy");
        row.publicAccess = rs.getInt("isPublic");
        row.lang = rs.getString("lang");
        return new ComponentInstLight(row);
    }

    public static List<String> getAllActiveComponentIds() throws SQLException {
        return JdbcSqlQuery.select((String)"componentName, id").from(new String[]{"ST_ComponentInstance"}).where("componentStatus IS NULL", new Object[0]).and("componentName", new Object[0]).in((Collection)WAComponent.getAll().stream().map(WAComponent::getName).collect(Collectors.toList())).orderBy(new String[]{"orderNum"}).execute(r -> r.getString(1) + r.getInt(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ComponentInstLight> getComponentsInSpace(Connection con, int spaceId) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            stmt = con.prepareStatement(QUERY_ALL_SPACE_INSTANCES);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                components.add(ComponentDAO.fetchComponentInstance(rs));
            }
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    public static List<String> getAllAvailableComponentIds(Connection con, List<String> groupIds, int userId, String componentName) throws SQLException {
        HashSet<String> componentIds = new HashSet<String>(ComponentDAO.getAllPublicComponentIds(con));
        if (StringUtil.isDefined((String)componentName)) {
            componentIds.removeIf(s -> !s.startsWith(componentName));
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            componentIds.addAll(ComponentDAO.getAllAvailableComponentIds(con, groupIds, componentName));
        }
        if (userId != -1) {
            componentIds.addAll(ComponentDAO.getAllAvailableComponentIds(con, userId, componentName));
        }
        return new ArrayList<String>(componentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAvailableComponentIds(Connection con, List<String> groupIds, String componentName) throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            String queryAllAvailableComponentIds = "select distinct(c.id), c.componentName from st_componentinstance c, st_userrole r, st_userrole_group_rel gr where c.id=r.instanceId and c.componentstatus is null and r.id=gr.userroleid and r.objectId is null and gr.groupId IN (" + ComponentDAO.list2String(groupIds) + ")";
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAllAvailableComponentIds);
            while (rs.next()) {
                String cName = rs.getString(2);
                if (StringUtil.isDefined((String)componentName) && (!StringUtil.isDefined((String)componentName) || !componentName.equalsIgnoreCase(cName))) continue;
                ids.add(cName + rs.getInt(1));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAvailableComponentIds(Connection con, int userId, String componentName) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(QUERY_ALL_AVAILABLE_COMPONENT_IDS);
            stmt.setInt(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String cName = rs.getString(2);
                if (StringUtil.isDefined((String)componentName) && (!StringUtil.isDefined((String)componentName) || !componentName.equalsIgnoreCase(cName))) continue;
                ids.add(cName + rs.getInt(1));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllPublicComponentIds(Connection con) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            stmt = con.prepareStatement(QUERY_ALL_PUBLIC_COMPONENT_IDS);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(2) + rs.getInt(1));
            }
            arrayList = ids;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    public static List<String> getAvailableComponentIdsInSpace(Connection con, List<String> groupIds, int userId, int spaceId, String componentName) throws SQLException {
        HashSet<ComponentInstLight> componentsSet = new HashSet<ComponentInstLight>(ComponentDAO.getPublicComponentsInSpace(con, spaceId));
        if (groupIds != null && !groupIds.isEmpty()) {
            componentsSet.addAll(ComponentDAO.getAvailableComponentsInSpace(con, groupIds, spaceId, componentName));
        }
        componentsSet.addAll(ComponentDAO.getAvailableComponentsInSpace(con, userId, spaceId, componentName));
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>(componentsSet);
        components.sort(new ComponentInstLightSorter());
        ArrayList<String> componentIds = new ArrayList<String>();
        for (ComponentInstLight component : components) {
            componentIds.add(component.getId());
        }
        return componentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getAvailableComponentsInSpace(Connection con, List<String> groupIds, int spaceId, String componentName) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            Object queryAvailableComponentIdsInSpace = "select distinct(c.id), c.componentName, c.ordernum from st_componentinstance c, st_userrole r, st_userrole_group_rel gr where c.id=r.instanceId";
            if (StringUtil.isDefined((String)componentName)) {
                queryAvailableComponentIdsInSpace = (String)queryAvailableComponentIdsInSpace + " and c.componentName = '" + componentName + "'";
            }
            queryAvailableComponentIdsInSpace = (String)queryAvailableComponentIdsInSpace + " and c.componentstatus is null and c.spaceId = " + spaceId + " and r.id=gr.userroleid and r.objectId is null and gr.groupId IN (" + ComponentDAO.list2String(groupIds) + ")";
            stmt = con.createStatement();
            rs = stmt.executeQuery((String)queryAvailableComponentIdsInSpace);
            ComponentDAO.makeComponentInst(rs, components);
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getAvailableComponentsInSpace(Connection con, int userId, int spaceId, String componentName) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            String queryAvailableComponentIdsInSpace = " select distinct(c.id), c.componentName, c.ordernum from st_componentinstance c, st_userrole r, st_userrole_user_rel ur where c.spaceId = " + spaceId;
            if (StringUtil.isDefined((String)componentName)) {
                queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.componentName = '" + componentName + "'";
            }
            queryAvailableComponentIdsInSpace = queryAvailableComponentIdsInSpace + " and c.id=r.instanceId and c.componentstatus is null and r.id=ur.userroleid and r.objectId is null and ur.userId = " + userId;
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAvailableComponentIdsInSpace);
            ComponentDAO.makeComponentInst(rs, components);
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    private static void makeComponentInst(ResultSet rs, List<ComponentInstLight> components) throws SQLException {
        while (rs.next()) {
            ComponentInstLight component = new ComponentInstLight();
            component.setLocalId(rs.getInt(1));
            component.setOrderNum(rs.getInt(3));
            component.setName(rs.getString(2));
            components.add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ComponentInstLight> getPublicComponentsInSpace(Connection con, int spaceId) throws SQLException {
        ArrayList<ComponentInstLight> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
            stmt = con.prepareStatement(QUERY_PUBLIC_COMPONENT_IDS_IN_SPACE);
            stmt.setInt(1, spaceId);
            rs = stmt.executeQuery();
            ComponentDAO.makeComponentInst(rs, components);
            arrayList = components;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }
}

