/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.silverpeas.core.admin.RightProfile;

public abstract class BaseRightProfile
implements RightProfile,
Serializable {
    private String id = "";
    private String name = "";
    private String label = "";
    private String description = "";
    private boolean isInherited = false;
    private final List<String> groups = new ArrayList<String>();
    private final List<String> users = new ArrayList<String>();

    protected BaseRightProfile() {
    }

    protected BaseRightProfile(BaseRightProfile profile) {
        this.name = profile.name;
        this.description = profile.description;
        this.label = profile.label;
        this.isInherited = profile.isInherited;
        this.groups.addAll(profile.groups);
        this.users.addAll(profile.users);
    }

    public void setId(String sId) {
        this.id = sId;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String sName) {
        this.name = sName;
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String sLabel) {
        this.label = sLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDescription(String sDescription) {
        this.description = sDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public void setInherited(boolean isInherited) {
        this.isInherited = isInherited;
    }

    public int getNumGroup() {
        return this.groups.size();
    }

    @Override
    public void addGroup(String sGroupId) {
        if (!this.groups.contains(sGroupId)) {
            this.groups.add(sGroupId);
        }
    }

    @Override
    public void removeGroup(String sGroupId) {
        this.groups.remove(sGroupId);
    }

    @Override
    public List<String> getAllGroups() {
        return this.groups;
    }

    public void removeAllGroups() {
        this.groups.clear();
    }

    public int getNumUser() {
        return this.users.size();
    }

    @Override
    public void addUser(String sUserId) {
        if (!this.users.contains(sUserId)) {
            this.users.add(sUserId);
        }
    }

    @Override
    public void removeUser(String sUserId) {
        this.users.remove(sUserId);
    }

    @Override
    public List<String> getAllUsers() {
        return this.users;
    }

    public void removeAllUsers() {
        this.users.clear();
    }

    public void addUsers(List<String> users) {
        ArrayList<String> a2 = new ArrayList<String>(users);
        a2.removeAll(this.users);
        this.users.addAll(a2);
    }

    public void addGroups(List<String> groups) {
        ArrayList<String> a2 = new ArrayList<String>(groups);
        a2.removeAll(this.groups);
        this.groups.addAll(a2);
    }

    public void setUsers(List<String> users) {
        this.users.clear();
        this.users.addAll(users);
    }

    public void setGroups(List<String> groups) {
        this.groups.clear();
        this.groups.addAll(groups);
    }

    public boolean isEmpty() {
        return this.groups.isEmpty() && this.users.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRightProfile that = (BaseRightProfile)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

