/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.pio;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Closer
implements Closeable {
    private final Deque<Closeable> closeables = new ArrayDeque<Closeable>(3);
    private boolean suppressExceptionsOnClose = false;

    private Closer() {
    }

    public static Closer create() {
        return new Closer();
    }

    @Nullable
    public <C extends Closeable> C register(@Nullable C closeable) {
        if (closeable != null) {
            this.closeables.add(closeable);
        }
        return closeable;
    }

    @Override
    public void close() throws IOException {
        Throwable toThrow = null;
        while (!this.closeables.isEmpty()) {
            Closeable closeable = this.closeables.removeLast();
            try {
                closeable.close();
            }
            catch (Throwable exception) {
                if (toThrow != null) continue;
                toThrow = exception;
            }
        }
        if (!this.suppressExceptionsOnClose && toThrow != null) {
            if (toThrow instanceof IOException) {
                throw (IOException)toThrow;
            }
            throw (RuntimeException)toThrow;
        }
    }

    public RuntimeException rethrow(@NotNull Throwable throwable) throws IOException {
        Objects.requireNonNull(throwable);
        this.suppressExceptionsOnClose = true;
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new RuntimeException(throwable);
    }
}

