/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.versioning;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.contribution.content.form.XMLField;
import org.silverpeas.core.importexport.form.XMLModelContentType;
import org.silverpeas.core.importexport.versioning.DocumentVersionPK;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.xml.DateAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class DocumentVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_VALIDATION_NOT_REQ = 0;
    public static final int TYPE_DEFAULT_VERSION = 1;
    public static final int TYPE_PUBLIC_VERSION = 0;
    private static final String CONTEXT = "Versioning";
    private DocumentVersionPK pk;
    @XmlElement(name="majorNumber")
    private int majorNumber;
    @XmlElement(name="minorNumber")
    private int minorNumber;
    @XmlElement(name="creatorId", defaultValue="-1")
    private int authorId = -1;
    @XmlElement(name="creationDate")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date creationDate;
    @XmlElement(name="description")
    private String comments;
    @XmlElement(name="versionType")
    private int type = 1;
    @XmlAttribute(name="path")
    private String physicalName;
    private String logicalName;
    private String mimeType;
    private long size;
    private String instanceId;
    private String xmlForm = null;
    @XmlElement(name="creatorName")
    private String creatorName;
    @XmlElement(name="xmlModel")
    private XMLModelContentType xmlModelContentType = null;
    @XmlAttribute
    private boolean removeAfterImport = false;
    private String originalPath;

    public DocumentVersionPK getPk() {
        return this.pk;
    }

    public void setPk(DocumentVersionPK pk) {
        this.pk = pk;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public void setMajorNumber(int majorNumber) {
        this.majorNumber = majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public void setMinorNumber(int minorNumber) {
        this.minorNumber = minorNumber;
    }

    public int getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(int authorId) {
        this.authorId = authorId;
    }

    public Date getCreationDate() {
        if (this.creationDate != null) {
            return new Date(this.creationDate.getTime());
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = new Date(creationDate.getTime());
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(String logicalName) {
        this.logicalName = logicalName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String toString() {
        return "DocumentVersion object : [  pk = " + String.valueOf(this.pk) + ", majorNumber = " + this.majorNumber + ", minorNumber = " + this.minorNumber + ", authorId = " + this.authorId + ", creationDate = " + String.valueOf(this.creationDate) + ", comments = " + this.comments + ", type = " + this.type + ", physicalName = " + this.physicalName + ", logicalName = " + this.logicalName + ", mimeType = " + this.mimeType + ", size = " + this.size + " ];";
    }

    public String getDocumentPath() {
        if (this.isPhysicalPathAbsolute()) {
            return FilenameUtils.separatorsToSystem((String)this.physicalName);
        }
        Object directory = FileRepositoryManager.getAbsolutePath((String)this.getInstanceId(), (String[])new String[]{CONTEXT});
        if (!((String)(directory = FilenameUtils.separatorsToSystem((String)directory))).endsWith(File.separator)) {
            directory = (String)directory + File.separator;
        }
        return (String)directory + this.getPhysicalName();
    }

    private boolean isPhysicalPathAbsolute() {
        String filePath = FilenameUtils.separatorsToSystem((String)this.physicalName);
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getXmlForm() {
        return this.xmlForm;
    }

    public void setXmlForm(String xmlForm) {
        this.xmlForm = xmlForm;
    }

    public XMLModelContentType getXMLModelContentType() {
        return this.xmlModelContentType;
    }

    public void setXMLModelContentType(XMLModelContentType xmlModelContentType) {
        this.xmlModelContentType = xmlModelContentType;
    }

    public boolean isRemoveAfterImport() {
        return this.removeAfterImport;
    }

    public void setRemoveAfterImport(boolean removeAfterImport) {
        this.removeAfterImport = removeAfterImport;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public DocumentVersion copy() {
        DocumentVersion copy = new DocumentVersion();
        copy.pk = this.pk;
        copy.majorNumber = this.majorNumber;
        copy.minorNumber = this.minorNumber;
        copy.authorId = this.authorId;
        copy.creationDate = this.creationDate;
        copy.comments = this.comments;
        copy.type = this.type;
        copy.physicalName = this.physicalName;
        copy.logicalName = this.logicalName;
        copy.size = this.size;
        copy.instanceId = this.instanceId;
        copy.xmlForm = this.xmlForm;
        copy.creatorName = this.creatorName;
        copy.xmlModelContentType = this.xmlModelContentType;
        copy.removeAfterImport = this.removeAfterImport;
        copy.originalPath = this.originalPath;
        if (this.xmlModelContentType != null) {
            copy.xmlModelContentType = new XMLModelContentType(this.xmlModelContentType.getName());
            List<XMLField> fields = copy.xmlModelContentType.getFields().stream().map(f -> new XMLField(f.getName(), f.getValue())).collect(Collectors.toList());
            copy.xmlModelContentType.setFields(fields);
        }
        return copy;
    }
}

