/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.report;

import java.util.Date;
import java.util.HashMap;
import org.silverpeas.core.importexport.report.ComponentReport;
import org.silverpeas.core.importexport.report.ImportReport;
import org.silverpeas.core.importexport.report.MassiveReport;
import org.silverpeas.core.importexport.report.UnitReport;

public class ImportReportManager {
    private static ImportReport importReport = null;
    private static HashMap<String, ComponentReport> componentReportMap = null;

    public ImportReportManager() {
        importReport = new ImportReport();
        componentReportMap = new HashMap();
        importReport.setStartDate(new Date());
    }

    public ComponentReport getComponentReport(String componentId) {
        ComponentReport componentReport = componentReportMap.get(componentId);
        if (componentReport == null) {
            componentReport = new ComponentReport(componentId);
            componentReportMap.put(componentId, componentReport);
            importReport.addComponentReport(componentReport);
        }
        return componentReport;
    }

    public void setComponentName(String componentId, String componentName) {
        this.getComponentReport(componentId).setComponentName(componentName);
    }

    public void addMassiveReport(MassiveReport massiveReport, String componentId) {
        this.getComponentReport(componentId).addMassiveReport(massiveReport);
    }

    public void addUnitReport(UnitReport unitReport, String componentId) {
        this.getComponentReport(componentId).addUnitReport(unitReport);
    }

    public void addImportedFileSize(long size, String componentId) {
        this.getComponentReport(componentId).addImportedFileSize(size);
    }

    public ImportReport getImportReport() {
        return importReport;
    }

    public void reportImportEnd() {
        importReport.setEndDate(new Date());
    }

    public void addNumberOfFilesProcessed(int n) {
        importReport.addNumberOfFilesProcessed(n);
    }

    public void addNumberOfFilesNotImported(int n) {
        importReport.addNbFilesNotImported(n);
    }
}

