/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.silverpeas.core.admin.component.model.ComponentSearchCriteria;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverpeasContentManager;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.AxisHeader;
import org.silverpeas.core.pdc.pdc.model.AxisValueCriterion;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.SearchContext;
import org.silverpeas.core.pdc.pdc.model.SearchCriteria;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.webapi.pdc.PdcFilterCriteria;
import org.silverpeas.core.webapi.pdc.PdcPositionDeletionException;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;

@Provider
public class PdcServiceProvider {
    @Inject
    private PdcManager pdcManager;
    @Inject
    private ContentManagementEngine contentMgtEngine;
    @Inject
    private PdcClassificationService classificationService;
    @Inject
    private OrganizationController organisationController;

    public static String inComponentOfId(String componentId) {
        return componentId;
    }

    public static String forContentOfId(String contentId) {
        return contentId;
    }

    public void addPosition(ClassifyPosition position, String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverContentId = this.getSilverContentId(contentId, componentId);
        int positionId = this.getPdcManager().addPosition(silverContentId, position, componentId);
        position.setPositionId(positionId);
    }

    public void updatePosition(ClassifyPosition position, String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverContentId = this.getSilverContentId(contentId, componentId);
        this.getPdcManager().updatePosition(position, componentId, silverContentId);
    }

    public void deletePosition(int positionId, String contentId, String componentId) throws PdcException, ContentManagerException {
        List<UsedAxis> axis = this.getAxisUsedInPdcFor(componentId);
        List<ClassifyPosition> positions = this.getAllPositions(contentId, componentId);
        if (positions.size() == 1) {
            for (UsedAxis anAxis : axis) {
                if (anAxis.getMandatory() != 1) continue;
                throw new PdcPositionDeletionException("Cannot delete value", new String[0]);
            }
        }
        this.getPdcManager().deletePosition(positionId, componentId);
    }

    public List<ClassifyPosition> getAllPositions(String contentId, String componentId) throws ContentManagerException, PdcException {
        int silverContentId = this.getOrCreateSilverContentId(contentId, componentId);
        return this.getPdcManager().getPositions(silverContentId, componentId);
    }

    PdcClassification findPredefinedClassificationForContentsIn(String nodeId, String componentId) {
        return this.classificationService.findAPreDefinedClassification(nodeId, componentId);
    }

    PdcClassification getPredefinedClassification(String nodeId, String componentId) {
        return this.classificationService.getPreDefinedClassification(nodeId, componentId);
    }

    PdcClassification saveOrUpdatePredefinedClassification(PdcClassification predefinedClassification) {
        PdcClassification savedClassification = this.classificationService.savePreDefinedClassification(predefinedClassification);
        if (savedClassification == PdcClassification.NONE_CLASSIFICATION) {
            savedClassification = this.findPredefinedClassificationForContentsIn(predefinedClassification.getNodeId(), predefinedClassification.getComponentInstanceId());
        }
        return savedClassification;
    }

    public List<UsedAxis> getAxisUsedInPdcToClassify(String contentId, String inComponentId) throws ContentManagerException, PdcException {
        int silverContentId = this.getOrCreateSilverContentId(contentId, inComponentId);
        return this.getPdcManager().getUsedAxisToClassify(inComponentId, silverContentId);
    }

    public List<UsedAxis> getAxisUsedInPdcFor(String componentId) throws PdcException {
        return this.getPdcManager().getUsedAxisToClassify(componentId, -1);
    }

    public UserThesaurusHolder getThesaurusOfUser(UserDetail user) {
        return UserThesaurusHolder.holdThesaurus(UserThesaurusHolder.forUser(user));
    }

    public List<UsedAxis> getAxisUsedInClassificationsByCriteria(PdcFilterCriteria criteria) throws PdcException {
        ComponentSearchCriteria searchCriteria = new ComponentSearchCriteria().onComponentInstances(criteria.getComponentInstanceIds()).onWorkspace(criteria.getWorkspaceId()).onUser(criteria.getUser());
        SearchContext searchContext = this.setUpSearchContextFromCriteria(criteria);
        List availableComponents = this.getOrganisationController().getSearchableComponentsByCriteria(searchCriteria);
        List allAxis = this.getPdcManager().getAxisByType("P");
        List<UsedAxis> filteredAxis = this.filterAxis(allAxis, searchContext, availableComponents);
        ArrayList<UsedAxis> usedAxis = new ArrayList<UsedAxis>(filteredAxis);
        if (criteria.hasSecondaryAxisToBeIncluded()) {
            allAxis = this.getPdcManager().getAxisByType("S");
            filteredAxis = this.filterAxis(allAxis, searchContext, availableComponents);
            usedAxis.addAll(filteredAxis);
        }
        return usedAxis;
    }

    public List<Axis> getAllAxis() throws PdcException {
        ArrayList<Axis> pdcAxis = new ArrayList<Axis>();
        List headers = this.getPdcManager().getAxis();
        for (AxisHeader aHeader : headers) {
            String treeId = this.getPdcManager().getTreeId(aHeader.getPK().getId());
            List values = this.getPdcManager().getAxisValues(Integer.parseInt(treeId));
            pdcAxis.add(new Axis(aHeader, values));
        }
        return pdcAxis;
    }

    private PdcManager getPdcManager() {
        return this.pdcManager;
    }

    private ContentManagementEngine getContentManagerEngine() {
        return this.contentMgtEngine;
    }

    public OrganizationController getOrganisationController() {
        return this.organisationController;
    }

    private int getSilverContentId(String ofTheContent, String inTheComponent) throws ContentManagerException {
        return this.getContentManagerEngine().getSilverContentId(ofTheContent, inTheComponent);
    }

    private int getOrCreateSilverContentId(String ofTheContent, String inTheComponent) throws ContentManagerException {
        Optional contentManager;
        int silverpeasContentId = this.getSilverContentId(ofTheContent, inTheComponent);
        if (silverpeasContentId == -1 && (contentManager = SilverpeasContentManager.getByInstanceId((String)inTheComponent)).isPresent()) {
            return ((SilverpeasContentManager)contentManager.get()).getOrCreateSilverContentId(ofTheContent, inTheComponent);
        }
        return silverpeasContentId;
    }

    private SearchContext setUpSearchContextFromCriteria(PdcFilterCriteria criteria) {
        SearchContext context = new SearchContext(null);
        if (criteria.hasCriterionOnUser()) {
            context.setUserId(criteria.getUser().getId());
        }
        if (criteria.hasCriterionOnAxisValues()) {
            for (AxisValueCriterion axisValueCriterion : criteria.getAxisValues()) {
                context.addCriteria((SearchCriteria)axisValueCriterion);
            }
        }
        return context;
    }

    private UsedAxis createUsedAxis(AxisHeader axisHeader, List<Value> values) throws PdcException {
        UsedAxis axis = new UsedAxis(axisHeader.getPK().getId(), "", axisHeader.getRootId(), 0, 0, 1);
        axis._setAxisHeader(axisHeader);
        axis._setAxisName(axisHeader.getName());
        axis._setAxisType(axisHeader.getAxisType());
        axis._setBaseValueName(axisHeader.getName());
        axis._setAxisRootId(Integer.parseInt(this.getPdcManager().getRoot(axisHeader.getPK().getId()).getValuePK().getId()));
        axis._setAxisValues(values);
        return axis;
    }

    private List<UsedAxis> filterAxis(List<AxisHeader> axisHeaders, SearchContext searchContext, List<String> availableComponents) throws PdcException {
        ArrayList<UsedAxis> filteredAxis = new ArrayList<UsedAxis>();
        for (AxisHeader axisHeader : axisHeaders) {
            List values = this.getPdcManager().getPertinentDaughterValuesByInstanceIds(searchContext, axisHeader.getPK().getId(), "0", availableComponents);
            if (values == null || values.isEmpty()) continue;
            UsedAxis usedAxis = this.createUsedAxis(axisHeader, values);
            filteredAxis.add(usedAxis);
        }
        return filteredAxis;
    }
}

