/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.user;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessage;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILPersistence;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteria;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.notification.user.InboxUserNotificationEntity;
import org.silverpeas.core.webapi.notification.user.InboxUserNotificationResourceURIs;

@WebService
@Path(value="usernotifications/inbox")
@Authenticated
public class InboxUserNotificationResource
extends RESTWebService {
    @Inject
    private InboxUserNotificationResourceURIs uri;

    public String getComponentId() {
        return "";
    }

    protected String getResourceBasePath() {
        return "usernotifications/inbox";
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public InboxUserNotificationEntity get(@PathParam(value="id") long id) {
        return (InboxUserNotificationEntity)this.process(() -> this.asWebEntity(SILVERMAILPersistence.getMessage((String)this.getUser().getId(), (long)id))).lowestAccessRole(null).execute();
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="id") long id) {
        this.process(() -> {
            SILVERMAILPersistence.deleteMessage((String)this.getUser().getId(), (long)id);
            return null;
        }).lowestAccessRole(null).execute();
        return Response.ok().build();
    }

    @GET
    @Path(value="{id}/read")
    @Produces(value={"application/json"})
    public InboxUserNotificationEntity markAsRead(@PathParam(value="id") long id) {
        return (InboxUserNotificationEntity)this.process(() -> this.asWebEntity(SILVERMAILPersistence.getMessageAndMarkAsRead((String)this.getUser().getId(), (long)id))).lowestAccessRole(null).execute();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllPaginated(@QueryParam(value="page") String page) {
        SilverpeasList notifications;
        PaginationPage pagination = this.fromPage(page);
        if (pagination == null) {
            pagination = PaginationPage.DEFAULT;
        }
        try {
            notifications = SILVERMAILPersistence.getMessageOfFolder((String)this.getUser().getId(), (String)"INBOX", (PaginationPage)pagination, (SilvermailCriteria.QUERY_ORDER_BY)SilvermailCriteria.QUERY_ORDER_BY.RECEPTION_DATE_DESC);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return Response.ok(this.asWebEntities((Collection<SILVERMAILMessage>)notifications)).header("X-Silverpeas-Size", (Object)notifications.originalListSize()).build();
    }

    @PUT
    @Produces(value={"application/json"})
    public Response markAsRead(List<InboxUserNotificationEntity> entities) {
        if (entities.isEmpty()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        SILVERMAILPersistence.markMessagesAsRead((String)this.getUser().getId(), (Collection)entities.stream().map(InboxUserNotificationEntity::getId).map(String::valueOf).collect(Collectors.toList()));
        return Response.ok().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete(List<InboxUserNotificationEntity> entities) {
        if (entities.isEmpty()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        SILVERMAILPersistence.deleteMessages((String)this.getUser().getId(), (Collection)entities.stream().map(InboxUserNotificationEntity::getId).map(String::valueOf).collect(Collectors.toList()));
        return Response.ok().build();
    }

    public List<InboxUserNotificationEntity> asWebEntities(Collection<SILVERMAILMessage> notifications) {
        return notifications.stream().map(this::asWebEntity).collect(Collectors.toList());
    }

    public InboxUserNotificationEntity asWebEntity(SILVERMAILMessage notification) {
        if (notification == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!String.valueOf(notification.getUserId()).equals(this.getUser().getId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return InboxUserNotificationEntity.from(notification).withURI(this.uri.ofNotification(notification)).withMarkAsReadURI(this.uri.ofNotificationToMarkAsRead(notification));
    }
}

