/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.node;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.node.NodeEntity;

@WebService
@Path(value="nodes/{instanceId}")
@Authorized
public class ListNodeResource
extends RESTWebService {
    static final String PATH = "nodes";
    @Inject
    private NodeService nodeService;
    @PathParam(value="instanceId")
    private String instanceId;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.instanceId;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    private boolean isUserAdmin() {
        String[] profiles;
        for (String profile : profiles = this.getOrganisationController().getUserProfiles(this.getUser().getId(), this.getComponentId())) {
            if (!SilverpeasRole.ADMIN.equals((Object)SilverpeasRole.fromString((String)profile))) continue;
            return true;
        }
        return false;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NodeEntity[] updateListNode(NodeEntity[] newListNode) {
        if (this.isUserAdmin()) {
            ArrayList<NodePK> nodePKs = new ArrayList<NodePK>();
            for (NodeEntity nodeEntity : newListNode) {
                nodePKs.add(nodeEntity.toNodePK());
            }
            this.getNodeService().sortNodes(nodePKs);
        }
        return newListNode;
    }
}

