/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.node;

import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.node.NodeEntity;

public abstract class AbstractNodeResource
extends RESTWebService {
    @PathParam(value="componentId")
    protected String componentId;

    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public NodeEntity getRoot() {
        return this.getRootNode();
    }

    @GET
    @Path(value="{path: [0-9]+(/[0-9]+)*}")
    @Produces(value={"application/json"})
    public NodeEntity getNode(@PathParam(value="path") String path) {
        return this.getNodeByPath(path);
    }

    @GET
    @Path(value="{path: [0-9]+(/[0-9]+)*/children}")
    @Produces(value={"application/json"})
    public NodeEntity[] getChildren(@PathParam(value="path") String path) {
        return this.getChildrenOfNodeByPath(path);
    }

    protected NodeEntity getRootNode() {
        NodeDetail node = this.getNodeDetail("0");
        if (this.isNodeNotReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        URI uri = this.getUri().getRequestUriBuilder().path(node.getNodePK().getId()).build(new Object[0]);
        if (this.getUri().getRequestUri().toString().endsWith("/0")) {
            uri = this.getUri().getRequestUri();
        }
        NodeEntity entity = NodeEntity.fromNodeDetail(this.getHighestUserRoleIfAny(), node, uri);
        entity.getState().setOpened(true);
        entity.setChildren(this.removeSpecialNodes(entity.getChildren()));
        return entity;
    }

    protected NodeEntity getNodeByPath(String path) {
        String nodeId = this.getNodeIdFromURI(path);
        if (nodeId.equals("0")) {
            return this.getRootNode();
        }
        NodeDetail node = this.getNodeDetail(nodeId);
        if (this.isNodeNotReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        URI uri = this.getUri().getRequestUri();
        return NodeEntity.fromNodeDetail(this.getHighestUserRoleIfAny(), node, uri);
    }

    protected NodeEntity[] getChildrenOfNodeByPath(String path) {
        String[] nodeIds = path.split("/");
        String nodeId = nodeIds[nodeIds.length - 2];
        NodeDetail node = this.getNodeDetail(nodeId);
        if (this.isNodeNotReadable(node)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String requestUri = this.getUri().getRequestUri().toString();
        String uri = requestUri.substring(0, requestUri.lastIndexOf("/"));
        NodeEntity entity = NodeEntity.fromNodeDetail(this.getHighestUserRoleIfAny(), node, uri);
        if (nodeId.equals("0")) {
            return this.removeSpecialNodes(entity.getChildren());
        }
        return entity.getChildren();
    }

    protected abstract boolean isNodeReadable(NodeDetail var1);

    private boolean isNodeNotReadable(NodeDetail node) {
        return !this.isNodeReadable(node);
    }

    private String getNodeIdFromURI(String uri) {
        String[] nodeIds = uri.split("/");
        return nodeIds[nodeIds.length - 1];
    }

    private NodeDetail getNodeDetail(String id) {
        return this.getNodeService().getDetail(this.getNodePK(id));
    }

    private NodeEntity[] removeSpecialNodes(NodeEntity[] nodes) {
        ArrayList<NodeEntity> result = new ArrayList<NodeEntity>();
        for (NodeEntity node : nodes) {
            if (node.getAttr().getId().equals("1") || node.getAttr().getId().equals("2")) continue;
            result.add(node);
        }
        return result.toArray(new NodeEntity[0]);
    }

    private NodePK getNodePK(String id) {
        return new NodePK(id, this.getComponentId());
    }

    private NodeService getNodeService() {
        return NodeService.get();
    }

    private SilverpeasRole getHighestUserRoleIfAny() {
        return this.getUser() != null && this.getComponentId() != null ? this.getHighestUserRole() : null;
    }
}

