/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import edu.psu.swe.scim.spec.resources.Email;
import edu.psu.swe.scim.spec.resources.Name;
import edu.psu.swe.scim.spec.resources.ScimUser;
import java.util.ArrayList;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.kernel.util.StringUtil;

class SilverpeasScimServerConverter {
    private SilverpeasScimServerConverter() {
    }

    static UserFull convert(ScimUser scimUser) {
        if (scimUser == null) {
            return null;
        }
        UserFull user = new UserFull();
        user.setId(SilverpeasScimServerConverter.decodeUserId(scimUser.getId()));
        SilverpeasScimServerConverter.applyTo(scimUser, user);
        return user;
    }

    static void applyTo(ScimUser scimUser, UserFull user) {
        user.setSpecificId(scimUser.getExternalId());
        Name name = scimUser.getName();
        if (name != null) {
            user.setLastName(name.getFamilyName());
            user.setFirstName(name.getGivenName());
        } else {
            user.setLastName(null);
            user.setFirstName(null);
        }
        user.setLogin(scimUser.getUserName());
        String email = scimUser.getPrimaryEmailAddress().map(Email::getValue).orElse(scimUser.getUserName());
        user.setEmailAddress(email);
        user.setPassword(scimUser.getPassword());
        if (!user.isRemovedState()) {
            if (scimUser.getActive().booleanValue()) {
                if (user.isDeactivatedState() || user.isDeletedState()) {
                    user.setState(UserState.VALID);
                }
            } else {
                user.setState(UserState.DEACTIVATED);
            }
        }
    }

    static ScimUser convert(User user) {
        if (user == null) {
            return null;
        }
        ScimUser scimUser = new ScimUser();
        scimUser.setId(SilverpeasScimServerConverter.encodeUserId(user));
        SilverpeasScimServerConverter.applyTo(user, scimUser);
        return scimUser;
    }

    private static void applyTo(User genericUser, ScimUser scimUser) {
        if (genericUser instanceof UserDetail) {
            UserDetail user = (UserDetail)genericUser;
            scimUser.setExternalId(user.getSpecificId());
            scimUser.setUserName(user.getLogin());
            if (StringUtil.isDefined((String)user.getEmailAddress()) && !user.getLogin().equals(user.getEmailAddress())) {
                scimUser.setEmails(new ArrayList(1));
                Email email = new Email();
                email.setValue(user.getEmailAddress());
                email.setPrimary(Boolean.valueOf(true));
                scimUser.getEmails().add(email);
            }
            Name name = new Name();
            name.setGivenName(user.getFirstName());
            if (!user.getLogin().equals(user.getLastName())) {
                name.setFamilyName(user.getLastName());
                name.setFormatted(user.getDisplayedName());
            } else {
                name.setFormatted(user.getFirstName());
            }
            scimUser.setName(name);
            scimUser.setActive(Boolean.valueOf(user.isValidState()));
        }
    }

    private static String encodeUserId(User user) {
        return "sp@domain" + user.getDomainId() + "$" + user.getId();
    }

    static String decodeUserId(String encodedId) {
        if (StringUtil.isNotDefined((String)encodedId)) {
            return null;
        }
        String[] encodedSpId = encodedId.split("sp@domain");
        return encodedSpId.length == 1 ? encodedSpId[0] : encodedSpId[1].split("[$]")[1];
    }
}

