/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.window;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ecs.html.Div;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxy;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxyManager;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPane;
import org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPaneType;
import org.silverpeas.core.web.util.viewgenerator.html.window.Window;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractWindow
implements Window {
    private static final String DIV = "</div>";
    private BrowseBar browseBar = null;
    private OperationPane operationPane = null;
    private GraphicElementFactory gef = null;
    private String body = null;
    private String width = null;
    private boolean browserBarDisplayable = true;
    private boolean popup = false;
    String contextualDiv = null;

    @Override
    public void init(GraphicElementFactory gef) {
        this.gef = gef;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public void addBody(String body2) {
        this.body = body2;
    }

    public GraphicElementFactory getGEF() {
        return this.gef;
    }

    public String getIconsPath() {
        return GraphicElementFactory.getIconsPath();
    }

    @Override
    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        if (this.width == null) {
            this.width = "100%";
        }
        return this.width;
    }

    @Override
    public OperationPane getOperationPane() {
        if (this.operationPane == null) {
            this.operationPane = this.getGEF().getOperationPane();
            if (!this.isPopup() && StringUtil.isDefined((String)this.getGEF().getComponentIdOfCurrentRequest())) {
                if (ResourceLocator.getGeneralSettingBundle().getBoolean("AdminFromComponentEnable", true)) {
                    this.addOperationToSetupComponent();
                }
                this.addOperationToEditComponentIntro();
            }
        }
        return this.operationPane;
    }

    private void addOperationToSetupComponent() {
        MainSessionController msc = this.getGEF().getMainSessionController();
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        String componentId = this.getGEF().getComponentIdOfCurrentRequest();
        boolean isComponentInstanceIdDefinedShareable = StringUtil.isDefined((String)componentId);
        if (isComponentInstanceIdDefinedShareable) {
            boolean bl = isComponentInstanceIdDefinedShareable = !PersonalComponentInstance.from((String)componentId).isPresent();
        }
        if (isComponentInstanceIdDefinedShareable && organizationController.isComponentManageable(componentId, msc.getUserId()) && this.getGEF().isComponentMainPage()) {
            String label = ResourceLocator.getGeneralLocalizationBundle((String)this.getGEF().getMultilang().getLocale().getLanguage()).getString("GML.operations.setupComponent");
            String url = "javascript:spWindow.setupComponent('" + componentId + "')";
            this.operationPane.addOperation(null, label, url);
            this.operationPane.addLine();
        }
    }

    private void addOperationToSetupSpace() {
        MainSessionController msc = this.getGEF().getMainSessionController();
        String currentSpaceId = this.getGEF().getSpaceIdOfCurrentRequest();
        if (msc.getCurrentUserDetail().isAccessAdmin() || ArrayUtil.contains((Object[])msc.getUserManageableSpaceIds(), (Object)currentSpaceId)) {
            String label = ResourceLocator.getGeneralLocalizationBundle((String)this.getGEF().getMultilang().getLocale().getLanguage()).getString("GML.operations.setupSpace");
            String url = "javascript:spWindow.setupSpace('" + currentSpaceId + "')";
            this.operationPane.addOperation(null, label, url);
            this.operationPane.addLine();
        }
    }

    private void addOperationToEditComponentIntro() {
        String currentComponentId = this.getGEF().getComponentIdOfCurrentRequest();
        if (!this.getGEF().isComponentMainPage() || currentComponentId.startsWith("kmelia")) {
            return;
        }
        if (this.isUserAllowedToEditComponentIntro(currentComponentId)) {
            String label = ResourceLocator.getGeneralLocalizationBundle((String)this.getGEF().getMultilang().getLocale().getLanguage()).getString("GML.operations.editComponentIntro");
            String url = "EditComponentInstanceIntro";
            this.operationPane.addOperation(null, label, url);
            this.operationPane.addLine();
        }
    }

    private boolean isUserAllowedToEditComponentIntro(String componentId) {
        MainSessionController msc;
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        Object[] profiles = organizationController.getUserProfiles((msc = this.getGEF().getMainSessionController()).getUserId(), componentId);
        return ArrayUtil.contains((Object[])profiles, (Object)SilverpeasRole.ADMIN.getName()) || ArrayUtil.contains((Object[])profiles, (Object)SilverpeasRole.SUPERVISOR.getName()) || ArrayUtil.contains((Object[])profiles, (Object)"Administrator") || ArrayUtil.contains((Object[])profiles, (Object)"Admin");
    }

    @Override
    public BrowseBar getBrowseBar() {
        if (this.browseBar == null) {
            this.browseBar = this.getGEF().getBrowseBar();
        }
        return this.browseBar;
    }

    public String getContextualDiv() {
        String componentId = this.getGEF().getComponentIdOfCurrentRequest();
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        String spaceIds = Optional.ofNullable(componentId).filter(StringUtil::isDefined).stream().flatMap(i -> oc.getPathToComponent(i).stream()).map(s -> s.getId() + " ").collect(Collectors.joining());
        if (!spaceIds.isEmpty()) {
            ComponentInstLight component = oc.getComponentInstLight(componentId);
            String userId = User.getCurrentRequester().getId();
            String cssProfiles = Optional.ofNullable(oc.getUserProfiles(userId, componentId)).stream().flatMap(Stream::of).map(p -> " profile_" + p).collect(Collectors.joining());
            return "<div class=\"" + spaceIds + component.getName() + " " + componentId + cssProfiles + "\">";
        }
        return null;
    }

    @Override
    public boolean isBrowseBarVisible() {
        return this.browserBarDisplayable;
    }

    @Override
    public void setBrowseBarVisibility(boolean browseBarVisible) {
        this.browserBarDisplayable = browseBarVisible;
    }

    @Override
    public boolean isPopup() {
        return this.popup;
    }

    @Override
    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    private String getWelcomeMessage(SilverpeasComponentInstance component, String language) {
        String message = null;
        try {
            String fileName = "welcome_" + language;
            message = this.getSilverpeasTemplate().applyFileTemplateOnComponent(component.getName(), fileName);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e).info("App ''{0}'' has no welcome message yet !", new Object[]{component.getName()});
        }
        if (!StringUtil.isDefined((String)message)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        String title2 = this.getGEF().getMultilang().getString("GEF.welcome.title");
        sb.append("<div id=\"welcome-message\" title=\"").append(title2).append("\" style=\"display: none;\">\n");
        sb.append("<p>\n");
        sb.append(message);
        sb.append("</p>\n");
        sb.append("</div>\n");
        return sb.toString();
    }

    private SilverpeasTemplate getSilverpeasTemplate() {
        return SilverpeasTemplates.createSilverpeasTemplateOnComponents();
    }

    private String getWelcomeMessageScript(SilverpeasComponentInstance component) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var welcomeMessageAlreadyShown = false;\n");
        sb.append("$(function() {\n");
        sb.append("var welcomeMessageCookieName = \"Silverpeas_").append(component.getName()).append("_WelcomeMessage\";\n");
        sb.append("if (!welcomeMessageAlreadyShown && \"IKnowIt\" != $.cookie(welcomeMessageCookieName)) {\n");
        sb.append("if (!welcomeMessageAlreadyShown) {\n");
        sb.append("welcomeMessageAlreadyShown = true;\n");
        sb.append("$('#welcome-message').dialog({\n");
        sb.append("modal: true,\n");
        sb.append("resizable: false,\n");
        sb.append("width: 400,\n");
        sb.append("dialogClass: 'help-modal-message',\n");
        sb.append("buttons: {\n");
        sb.append("\"").append(this.getGEF().getMultilang().getString("GEF.welcome.button.ok")).append("\": function() {\n");
        sb.append("$.cookie(welcomeMessageCookieName, \"IKnowIt\", { expires: 3650, path: '/'");
        sb.append(", secure: ").append(HttpRequest.isCurrentRequestSecure()).append(" });\n");
        sb.append("$(this).dialog(\"close\");\n");
        sb.append(" }, \n");
        sb.append("\"").append(this.getGEF().getMultilang().getString("GEF.welcome.button.reminder")).append("\": function() {\n");
        sb.append(" $(this).dialog(\"close\");\n");
        sb.append(" }\n");
        sb.append("}\n");
        sb.append("});\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append(");\n");
        sb.append("</script>");
        return sb.toString();
    }

    public String displayWelcomeMessage() {
        String componentId;
        if (this.getGEF().isComponentMainPage() && StringUtil.isDefined((String)(componentId = this.getGEF().getComponentIdOfCurrentRequest()))) {
            StringBuilder sb = new StringBuilder(300);
            OrganizationControllerProvider.getOrganisationController().getComponentInstance(componentId).ifPresent(component -> {
                String language = this.getGEF().getMainSessionController().getFavoriteLanguage();
                String message = this.getWelcomeMessage((SilverpeasComponentInstance)component, language);
                if (message != null) {
                    sb.append(message);
                    sb.append(this.getWelcomeMessageScript((SilverpeasComponentInstance)component));
                }
            });
            return sb.toString();
        }
        return "";
    }

    protected void addSpaceOrComponentOperations() {
        String currentSpaceId = this.getGEF().getSpaceIdOfCurrentRequest();
        String currentComponentId = this.getGEF().getComponentIdOfCurrentRequest();
        boolean isComponentInstanceIdDefinedShareable = StringUtil.isDefined((String)currentComponentId);
        if (isComponentInstanceIdDefinedShareable) {
            boolean bl = isComponentInstanceIdDefinedShareable = !PersonalComponentInstance.from((String)currentComponentId).isPresent();
        }
        if (OperationPaneType.space.equals((Object)this.getOperationPane().getType()) && StringUtil.isDefined((String)currentSpaceId) || isComponentInstanceIdDefinedShareable) {
            String addFavAction;
            String addFavLabel;
            String viewMgrAction;
            String viewMgrLabel;
            SpaceHomepageProxy space;
            if (this.getOperationPane().nbOperations() > 0) {
                this.getOperationPane().addLine();
            }
            if (this.getGEF().isCurrentRequestFromSpaceHomepage() && StringUtil.isDefined((String)currentSpaceId) && StringUtil.isDefined((String)currentComponentId) && (space = SpaceHomepageProxyManager.get().getProxyOf(OrganizationController.get().getSpaceInstById(currentSpaceId))).getFirstPageType() == SpaceInst.FP_TYPE_COMPONENT_INST && currentComponentId.equals(space.getFirstPageExtraParam())) {
                this.getOperationPane().setType(OperationPaneType.space);
            }
            boolean addFavOperation = true;
            String currentUserId = this.getGEF().getMainSessionController().getUserId();
            LocalizationBundle bundle = ResourceLocator.getGeneralLocalizationBundle((String)this.getGEF().getMultilang().getLocale().getLanguage());
            if (OperationPaneType.space.equals((Object)this.getOperationPane().getType())) {
                viewMgrLabel = bundle.getString("GML.space.responsibles").replaceAll("''", "'");
                viewMgrAction = "displaySpaceResponsibles('" + currentUserId + "','" + currentSpaceId + "')";
                addFavLabel = bundle.getString("GML.favorite.space.add");
                addFavAction = "addFavoriteSpace('" + currentSpaceId + "')";
                this.addOperationToSetupSpace();
            } else {
                viewMgrLabel = bundle.getString("GML.component.responsibles").replaceAll("''", "'");
                viewMgrAction = "displayComponentResponsibles('" + currentUserId + "','" + currentComponentId + "')";
                addFavLabel = bundle.getString("GML.favorite.application.add");
                addFavAction = "addFavoriteApp('" + currentComponentId + "')";
                addFavOperation = this.getGEF().isComponentMainPage();
            }
            if (addFavOperation) {
                this.getOperationPane().addOperation("", addFavLabel, "javascript:" + addFavAction + ";", "space-or-application-favorites-operation");
            }
            this.getOperationPane().addOperation("", viewMgrLabel, "javascript:" + viewMgrAction + ";", "space-or-component-responsibles-operation");
        }
    }

    @Override
    public String printBefore() {
        boolean someOperations;
        StringBuilder result = new StringBuilder(200);
        if (!(this.isPopup() || User.getCurrentRequester().isAnonymous() || User.getCurrentRequester().isAccessGuest() || OperationPaneType.personalSpace.equals((Object)this.getOperationPane().getType()))) {
            this.addSpaceOrComponentOperations();
        }
        Object browseBarClass = "cellBrowseBar";
        boolean bl = someOperations = this.getOperationPane().nbOperations() > 0;
        if (!someOperations) {
            browseBarClass = (String)browseBarClass + " cellBrowseBarWithoutOperation";
        }
        this.contextualDiv = this.getContextualDiv();
        if (StringUtil.isDefined((String)this.contextualDiv)) {
            result.append(this.contextualDiv);
        }
        result.append("<div id=\"topPage\">");
        if (this.isBrowseBarVisible()) {
            if (this.isPopup()) {
                this.getBrowseBar().setClickable(false);
            }
            Div div2 = new Div(this.getBrowseBar().print());
            div2.setClass((String)browseBarClass);
            result.append(div2.toString());
            if (someOperations) {
                result.append("<div class=\"cellOperation\" >");
                result.append(this.getOperationPane().print());
                result.append(DIV);
            }
        }
        result.append("<div class=\"cellBodyWindows\">");
        return result.toString();
    }

    @Override
    public String printAfter() {
        StringBuilder result = new StringBuilder(200);
        String iconsPath = this.getIconsPath();
        result.append(DIV);
        if (!this.isPopup()) {
            result.append("<div class=\"sp_goToTop\"><a href=\"#topPage\"><img src=\"").append(iconsPath).append("/goTop.gif\" border=\"0\" alt=\"\"/></a></div>");
        } else {
            SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
            Object includePopupResizeJsDone = cache.get((Object)"@includePopupResizeJsDone@");
            if (includePopupResizeJsDone == null) {
                StringBuilder popupResizeJs = new StringBuilder();
                popupResizeJs.append("jQuery(document.body).ready(");
                popupResizeJs.append("function(){");
                popupResizeJs.append("currentPopupResize();");
                popupResizeJs.append("});");
                result.append(new script().setType("text/javascript").addElement(popupResizeJs.toString()).toString());
                cache.put((Object)"@includePopupResizeJsDone@", (Object)true);
            }
        }
        if (StringUtil.isDefined((String)this.contextualDiv)) {
            result.append(DIV);
        }
        result.append(this.displayWelcomeMessage());
        return result.toString();
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder(500);
        result.append(this.printBefore());
        result.append(this.getBody());
        result.append(this.printAfter());
        return result.toString();
    }
}

