/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.pagination;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.RenderParameters;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.PaginationList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.AbstractPagination;
import org.silverpeas.kernel.bundle.LocalizationBundle;

public interface Pagination
extends SimpleGraphicElement {
    public static final String ITEMS_PER_PAGE_PARAM = "ItemsPerPage";
    public static final String INDEX_PARAMETER_NAME = "PaginationPaneIndex";

    public static PaginationPage getPaginationPageFrom(RenderRequest request, PaginationPage currentPagination) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        RenderParameters renderParameters = request.getRenderParameters();
        renderParameters.getNames().forEach(name -> parameters.put((String)name, renderParameters.getValue(name)));
        return Pagination.getPaginationPageFrom(parameters, currentPagination);
    }

    public static PaginationPage getPaginationPageFrom(HttpServletRequest request, PaginationPage currentPagination) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        request.getParameterMap().forEach((key, value) -> parameters.put((String)key, value[0]));
        return Pagination.getPaginationPageFrom(parameters, currentPagination);
    }

    public static PaginationPage getPaginationPageFrom(Map<String, String> params, PaginationPage currentPagination) {
        String pageSizeAsString = params.get(ITEMS_PER_PAGE_PARAM);
        String itemIndexAsString = params.get(INDEX_PARAMETER_NAME);
        return AbstractPagination.getPaginationPageFrom(pageSizeAsString, itemIndexAsString, currentPagination);
    }

    default public Pair<Integer, Integer> getStartLastIndexes() {
        int firstIndex = this.getIndexForCurrentPage();
        int lastIndex = this.isLastPage() ? this.getLastItemIndex() : this.getIndexForNextPage();
        return Pair.of((Object)firstIndex, (Object)lastIndex);
    }

    default public <T> SilverpeasList<T> getPaginatedListFrom(List<T> list) {
        if (list instanceof SilverpeasList && ((SilverpeasList)list).isSlice()) {
            return (SilverpeasList)list;
        }
        Pair<Integer, Integer> indexes = this.getStartLastIndexes();
        List<T> lightList = list.subList((Integer)indexes.getLeft(), (Integer)indexes.getRight());
        return PaginationList.from(lightList, (long)list.size());
    }

    public void init(int var1, int var2, int var3);

    public void setAltPreviousPage(String var1);

    public void setAltNextPage(String var1);

    public void setActionSuffix(String var1);

    public int getIndexForPreviousPage();

    public int getIndexForDirectPage(int var1);

    public int getIndexForCurrentPage();

    public int getIndexForNextPage();

    public boolean isLastPage();

    public String printIndex();

    public String printIndex(String var1);

    public String printIndex(String var1, boolean var2);

    public int getNbItems();

    public int getFirstItemIndex();

    public int getLastItemIndex();

    public String printCounter();

    public void setBaseURL(String var1);

    public void setMultilang(LocalizationBundle var1);
}

