/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.formpanes;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormButtonSubmit;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormLabel;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormLine;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormPane;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormPaneWA;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormTextField;

public class FormSelect
extends FormLine {
    private int size;
    private int nbItems;
    private List<String> itemsLabels;
    private List<String> itemValues;
    private List<Boolean> itemsSelected;

    public FormSelect(String nam, String val) {
        super(nam, val);
        this.setLabel(nam);
        this.size = 1;
        this.itemsLabels = new ArrayList<String>();
        this.itemValues = new ArrayList<String>();
        this.itemsSelected = new ArrayList<Boolean>();
        this.nbItems = 0;
        this.setType("select");
    }

    public FormSelect(String nam, String val, String lab, int siz) {
        super(nam, val);
        this.setLabel(lab);
        this.size = siz;
        this.itemsLabels = new ArrayList<String>();
        this.itemValues = new ArrayList<String>();
        this.itemsSelected = new ArrayList<Boolean>();
        this.nbItems = 0;
        this.setType("select");
    }

    public void addItem(String itemsLabel, String itemValue, boolean selected) {
        this.itemsLabels.add(itemsLabel);
        this.itemValues.add(itemValue);
        this.itemsSelected.add(selected);
        ++this.nbItems;
    }

    public void addItem(String itemsLabel, String itemValue) {
        this.itemsLabels.add(itemsLabel);
        this.itemValues.add(itemValue);
        this.itemsSelected.add(Boolean.FALSE);
        ++this.nbItems;
    }

    @Override
    public String print() {
        StringBuilder retour = new StringBuilder("\n<td>").append(this.label).append("</td>");
        retour.append("\n<td><select name=\"").append(this.name).append("\" size=\"").append(String.valueOf(this.size)).append("\">");
        for (int i = 0; i < this.nbItems; ++i) {
            retour.append("\n<option value=\"").append(this.itemValues.get(i)).append("\"");
            if (this.itemsSelected.get(i).booleanValue()) {
                retour.append(" selected ");
            }
            retour.append(">").append(this.itemsLabels.get(i)).append("</option>");
        }
        retour.append("\n</select></td>");
        return retour.toString();
    }

    @Override
    public FormPane getDescriptor(String nam, String url, PageContext pc) {
        FormPaneWA fpw = new FormPaneWA(nam, url, pc);
        fpw.add(new FormLabel("configuratorTitle", "Configuration du FormLabel"));
        fpw.add(new FormTextField("configuratorLabelValue", "", "Entrez la valeur : "));
        fpw.add(new FormButtonSubmit("newConfiguratorSubmitButton", "Cr\u00e9er"));
        return fpw;
    }

    @Override
    public void getConfigurationByRequest(HttpServletRequest req) {
        this.setLabel(req.getParameter("configuratorLabelValue"));
    }

    @Override
    public String printDemo() {
        String retour = "\n<td>" + this.label + "</td>";
        retour = retour + "<td>" + this.value + "</td>";
        return retour;
    }

    @Override
    public String toXML() {
        String retour = "\n<field id=\"" + this.id + "\" type=\"label\">";
        retour = retour + "\n</field>";
        return retour;
    }
}

