/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.subscription.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.ComponentSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.NodeSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanProvider;
import org.silverpeas.core.web.subscription.bean.SubscriptionBeanService;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public abstract class AbstractSubscriptionBeanService
implements SubscriptionBeanService,
Initialization {
    public void init() {
        SubscriptionBeanProvider.registerSubscriptionBeanService(this);
    }

    protected abstract List<SubscriptionResourceType> getHandledSubscriptionResourceTypes();

    @Override
    public String getSubscriptionTypeListLabel(SubscriptionResourceType type, String language) {
        Optional<Object> label = CommonSubscriptionResourceConstants.COMPONENT.equals(type) ? Optional.of(this.getBundle(language).getString("application")) : (CommonSubscriptionResourceConstants.NODE.equals(type) ? Optional.of(this.getBundle(language).getString("thematique")) : Optional.empty());
        return label.orElse("");
    }

    @Override
    public List<AbstractSubscriptionBean> toSubscriptionBean(Collection<Subscription> subscriptions, String language) {
        OrganizationController controller = OrganizationController.get();
        ArrayList<AbstractSubscriptionBean> converted = new ArrayList<AbstractSubscriptionBean>();
        for (Subscription subscription : subscriptions) {
            SubscriptionResourceType currentType = subscription.getResource().getType();
            if (CommonSubscriptionResourceConstants.COMPONENT.equals(currentType)) {
                controller.getComponentInstance(subscription.getResource().getInstanceId()).ifPresent(i -> converted.add(new ComponentSubscriptionBean(subscription, (SilverpeasComponentInstance)i, language)));
                continue;
            }
            if (!CommonSubscriptionResourceConstants.NODE.equals(currentType)) continue;
            controller.getComponentInstance(subscription.getResource().getInstanceId()).ifPresent(i -> {
                NodePath path = NodeService.get().getPath((NodePK)subscription.getResource().getPK());
                converted.add(new NodeSubscriptionBean(subscription, path, (SilverpeasComponentInstance)i, language));
            });
        }
        return converted;
    }

    protected LocalizationBundle getBundle(String language) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.pdcSubscriptionPeas.multilang.pdcSubscriptionBundle", (String)language);
    }
}

