/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.portlets.portal.portletwindow;

import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.portletcontainer.invoker.InvokerException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletWindowInvokerUtils {
    private static final Logger logger = Logger.getLogger("org.silverpeas.core.web.portlets.portal.portletwindow", "org.silverpeas.portlets.PCDLogMessages");

    public static EntityID getEntityID(PortletWindowContext pwc, String portletWindowName) throws InvokerException {
        try {
            EntityID entityId = pwc.getEntityID(portletWindowName);
            return entityId;
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("PortletWindowInvokerUtils.getEntityID(): couldn't get entityIDPrefix for portlet window " + portletWindowName, pwce);
        }
    }

    public static Map getUserInfoMap(PortletWindowContext pwc, String portletWindowName) throws InvokerException {
        Map userInfoMap = null;
        try {
            String portletName = pwc.getPortletName(portletWindowName);
            userInfoMap = pwc.getUserInfoMap(portletName);
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("PortletWindowInvokerUtils.getUserInfoMap(): couldn't get roleMap for portlet window " + portletWindowName, pwce);
        }
        return userInfoMap;
    }

    public static Map getRoleMap(PortletWindowContext pwc, String portletWindowName) throws InvokerException {
        Map roleMap = null;
        try {
            String portletName = pwc.getPortletName(portletWindowName);
            roleMap = pwc.getRoleMap(portletName);
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("PortletWindowInvokerUtils.getRoleMap(): couldn't get roleMap for portlet window " + portletWindowName, pwce);
        }
        return roleMap;
    }

    public static String getPortletWindowTitle(PortletWindowContext pwc, String portletWindowName) throws InvokerException {
        String title2 = null;
        try {
            title2 = pwc.getPortletWindowTitle(portletWindowName, pwc.getLocaleString());
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("PortletWindowInvokerUtils.getPortletWindowTitle(): couldn't get title for portlet window " + portletWindowName, pwce);
        }
        return title2;
    }

    public static String getPortletTitle(String portletWindowName, PortletWindowContext pwc) throws InvokerException {
        String title2 = null;
        try {
            String portletName = pwc.getPortletName(portletWindowName);
            String localeString = pwc.getLocaleString();
            title2 = pwc.getTitle(portletName, localeString);
            if (title2 == null) {
                logger.log(Level.SEVERE, "PSPCD_CSPPD0021", new String[]{portletName, localeString});
            }
        }
        catch (PortletWindowContextException pwce) {
            throw new InvokerException("PortletWindowInvokerUtils.getPortletTitle(): couldn't get title for portlet " + portletWindowName, pwce);
        }
        return title2;
    }
}

