/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import org.silverpeas.core.web.mvc.webcomponent.Path;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeAfter;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeBefore;
import org.silverpeas.core.web.mvc.webcomponent.annotation.LowestRoleAccess;
import org.silverpeas.core.web.mvc.webcomponent.annotation.NavigationStep;

class HttpMethodPaths {
    private final Class<? extends Annotation> httpMethodClass;
    private Map<String, Path> pathRoutes = new HashMap<String, Path>();

    HttpMethodPaths(Class<? extends Annotation> httpMethodClass) {
        this.httpMethodClass = httpMethodClass;
    }

    public Class<? extends Annotation> getHttpMethodClass() {
        return this.httpMethodClass;
    }

    List<Path> addPaths(Set<javax.ws.rs.Path> paths, LowestRoleAccess lowestRoleAccess, Method resourceMethod, NavigationStep navigationStep, Annotation redirectTo, Produces produces, InvokeBefore invokeBefore, InvokeAfter invokeAfter) {
        ArrayList<Path> registredPaths = new ArrayList<Path>();
        if (paths.isEmpty()) {
            registredPaths.add(this.addPath("/", lowestRoleAccess, resourceMethod, navigationStep, redirectTo, produces, invokeBefore, invokeAfter));
        } else {
            for (javax.ws.rs.Path path : paths) {
                registredPaths.add(this.addPath(path.value(), lowestRoleAccess, resourceMethod, navigationStep, redirectTo, produces, invokeBefore, invokeAfter));
            }
        }
        return registredPaths;
    }

    private Path addPath(String path, LowestRoleAccess lowestRoleAccess, Method resourceMethod, NavigationStep navigationStep, Annotation redirectTo, Produces produces, InvokeBefore invokeBefore, InvokeAfter invokeAfter) {
        Path pathToRegister = new Path(path.replaceFirst("^/", ""), lowestRoleAccess, resourceMethod, navigationStep, redirectTo, produces, invokeBefore, invokeAfter);
        Path pathRoute = this.pathRoutes.get(pathToRegister.getPath());
        if (pathRoute != null) {
            throw new IllegalArgumentException("specified path for method " + resourceMethod.getName() + " already exists for method " + pathRoute.getResourceMethod().getName() + " -> " + path);
        }
        this.pathRoutes.put(pathToRegister.getPath(), pathToRegister);
        return pathToRegister;
    }

    public Path findPath(String path, boolean skipPathsWithVariables, WebComponentRequestContext requestContext) {
        Path foundPath = null;
        for (Map.Entry<String, Path> entry : this.pathRoutes.entrySet()) {
            if (!entry.getValue().matches(path, skipPathsWithVariables, requestContext)) continue;
            foundPath = entry.getValue();
            break;
        }
        return foundPath;
    }
}

