/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.route;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.logging.SilverLogger;

public class MainRequestRouter
extends HttpServlet {
    private static final long serialVersionUID = 5131039058584808582L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String webContext;
        HttpSession session = request.getSession(false);
        String uri = request.getRequestURI();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String requestUrl = request.getRequestURL().toString();
        String absolutePrefix = requestUrl.substring(0, requestUrl.length() - request.getRequestURI().length());
        if (pathInfo != null) {
            uri = uri.substring(0, uri.lastIndexOf(pathInfo));
        }
        if ((webContext = uri.substring(0, uri.lastIndexOf(servletPath))).charAt(webContext.length() - 1) == '/') {
            webContext = webContext.substring(0, webContext.length() - 1);
        }
        String fullAppContext = absolutePrefix + webContext;
        if (session != null) {
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            String lookFrame = gef.getLookFrame();
            if (lookFrame.startsWith("/")) {
                response.sendRedirect(response.encodeRedirectURL(fullAppContext + lookFrame));
            } else {
                response.sendRedirect(response.encodeRedirectURL(fullAppContext + "/admin/jsp/" + lookFrame));
            }
        } else {
            SilverLogger.getLogger((Object)((Object)this)).warn("It seems that it is not possible to create an HTTP session. Please verify SSL certificates...", new Object[0]);
            response.sendRedirect(response.encodeRedirectURL(fullAppContext + "/admin/jsp/silverpeas-main.jsp"));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

