/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.route;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMap;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractComponentInstanceRoutingMap
implements ComponentInstanceRoutingMap {
    private String instanceId;
    private String uriBuilderBase;
    private String baseForPages;
    private String webResourceBase;

    protected AbstractComponentInstanceRoutingMap() {
    }

    <T extends AbstractComponentInstanceRoutingMap> T init(String instanceId, String uriBuilderBase, String webResourceBase) {
        this.instanceId = instanceId;
        this.uriBuilderBase = uriBuilderBase;
        this.webResourceBase = webResourceBase;
        return (T)this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public URI getHomePage() {
        return this.newUriBuilder(this.getBaseForPages(), "Main").build(new Object[0]);
    }

    public URI getViewPage(ContributionIdentifier contributionIdentifier) {
        return this.newUriBuilder(this.getBaseForPages(), contributionIdentifier.getType(), contributionIdentifier.getLocalId()).build(new Object[0]);
    }

    public URI getEditionPage(ContributionIdentifier contributionIdentifier) {
        return this.uriBuilder(this.getViewPage(contributionIdentifier), "edit").build(new Object[0]);
    }

    public URI getPermalink(ContributionIdentifier contributionIdentifier) {
        String compInstId = StringUtil.isDefined((String)contributionIdentifier.getComponentInstanceId()) ? contributionIdentifier.getComponentInstanceId() : "?";
        ContributionIdentifier permalinkContributionId = ContributionIdentifier.from((String)compInstId, (String)contributionIdentifier.getLocalId(), (String)contributionIdentifier.getType());
        return this.newUriBuilder("/Contribution", StringUtil.asBase64((byte[])permalinkContributionId.asString().getBytes())).build(new Object[0]);
    }

    public UriBuilder getWebResourceUriBuilder() {
        return UriBuilder.fromPath((String)this.webResourceBase);
    }

    protected String getBaseForPages() {
        if (this.baseForPages == null) {
            Optional silverpeasComponent = SilverpeasComponent.getByInstanceId((String)this.getInstanceId());
            if (silverpeasComponent.isPresent()) {
                String specificRouter;
                SilverpeasComponent component = (SilverpeasComponent)silverpeasComponent.get();
                if (!component.isPersonal() && StringUtil.isDefined((String)(specificRouter = ((WAComponent)component).getRouter()))) {
                    this.baseForPages = specificRouter;
                }
                this.baseForPages = "/R" + component.getName() + "/" + this.getInstanceId();
            } else {
                this.baseForPages = "/R" + this.getInstanceId();
            }
        }
        return this.baseForPages;
    }

    protected UriBuilder newUriBuilder(String ... paths) {
        return this.uriBuilder(URI.create(this.uriBuilderBase), paths);
    }

    protected UriBuilder uriBuilder(URI uri, String ... paths) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        Arrays.stream(paths).forEach(arg_0 -> ((UriBuilder)uriBuilder).path(arg_0));
        return uriBuilder;
    }
}

