/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.web.look.TickerItem;
import org.silverpeas.kernel.bundle.SettingBundle;

public class Ticker {
    private String label = "";
    private Map<String, String> params = new HashMap<String, String>();
    private List<TickerItem> items = new ArrayList<TickerItem>();
    private boolean manager = false;
    private boolean linkOnItem = false;

    public Ticker(List<PublicationDetail> pubs, SettingBundle settings) {
        for (PublicationDetail pub : pubs) {
            this.items.add(new TickerItem(pub));
        }
        for (String key : settings.keySet()) {
            String param;
            if (!key.startsWith("ticker.plugin") || (param = settings.getString(key, null)) == null) continue;
            this.params.put(key.substring(key.lastIndexOf(".") + 1), param);
        }
        this.linkOnItem = settings.getBoolean("ticker.linkOnItem", false);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public List<TickerItem> getItems() {
        return this.items;
    }

    public void setManager(boolean manager) {
        this.manager = manager;
    }

    public boolean isManager() {
        return this.manager;
    }

    public boolean isLinkOnItem() {
        return this.linkOnItem;
    }
}

