/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.ical;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.web.calendar.ical.StringUtils;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public final class FeedUtilities {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; hu; rv:1.8.0.8) Gecko/20061025 Thunderbird/1.5.0.8";
    private static final long REMOTE_CALENDAR_RETURNCODE_OK = 200L;
    private static final long FEED_RETRY_MILLIS = 1000L;
    private static final int MAX_ATTEMPTS = 5;
    private static final CloseableHttpClient httpClient = HttpClients.createDefault();

    private FeedUtilities() {
    }

    public static byte[] loadFeed(String feedURL) throws SilverpeasException {
        return FeedUtilities.loadFeed(feedURL, null, null);
    }

    static byte[] loadFeed(String feedURL, String username, String password) throws SilverpeasException {
        try {
            HttpGet get = new HttpGet(feedURL);
            get.setHeader("User-Agent", USER_AGENT);
            if (StringUtil.isDefined((String)username)) {
                byte[] auth = StringUtils.encodeString(username + ":" + StringUtils.decodePassword(password), Charsets.UTF_8);
                get.setHeader("Authorization", "Basic " + StringUtils.encodeBASE64(auth));
            }
            return FeedUtilities.loadFeedBody(get);
        }
        catch (Exception e) {
            SilverLogger.getLogger(FeedUtilities.class).silent((Throwable)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new SilverpeasException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadFeedBody(HttpGet get) throws InterruptedException {
        byte[] bytes = null;
        for (int tries = 0; tries < 5; ++tries) {
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                int status = response.getStatusLine().getStatusCode();
                if ((long)status == 200L) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream((int)response.getEntity().getContentLength());
                    response.getEntity().writeTo((OutputStream)output);
                    bytes = output.toByteArray();
                    continue;
                }
                SilverLogger.getLogger(FeedUtilities.class).warn("Feed loading failed with Http status code {0}. Actual content fetched: {1}", new Object[]{status, Arrays.toString(bytes)});
                bytes = null;
                continue;
            }
            catch (Exception loadError) {
                SilverLogger.getLogger(FeedUtilities.class).warn("Feed loading failure after {0} attempts. {1}", new Object[]{tries, loadError.getMessage()});
                if (tries == 4) {
                    bytes = null;
                    SilverLogger.getLogger(FeedUtilities.class).error((Throwable)loadError);
                }
                Thread.sleep(1000L);
                continue;
            }
            finally {
                get.reset();
            }
        }
        return bytes;
    }

    static Calendar convertFeedToCalendar(SyndFeed feed, long eventLength) {
        Calendar calendar = new Calendar();
        PropertyList props = calendar.getProperties();
        props.add((Property)new ProdId("-//Silverpeas//iCal4j 1.0//FR"));
        props.add((Property)Version.VERSION_2_0);
        props.add((Property)CalScale.GREGORIAN);
        SyndEntry[] entries = FeedUtilities.getFeedEntries(feed);
        ComponentList events = calendar.getComponents();
        java.util.Date now = new java.util.Date();
        for (SyndEntry entry1 : entries) {
            SyndEntry entry = entry1;
            String url = entry.getLink();
            if (url == null || url.length() == 0) continue;
            java.util.Date date = entry.getPublishedDate();
            if (date == null) {
                date = now;
            }
            DateTime startDate = new DateTime(date);
            DateTime endDate = new DateTime(date.getTime() + eventLength);
            String title2 = entry.getTitle();
            title2 = title2 == null || title2.length() == 0 ? url : title2.trim();
            VEvent event = new VEvent((Date)startDate, (Date)endDate, title2);
            PropertyList args = event.getProperties();
            URI uri = URI.create(url);
            args.add((Property)new Url(uri));
            Location location = new Location(uri.getHost());
            args.add((Property)location);
            Uid uid = new Uid(url);
            args.add((Property)uid);
            SyndContent syndContent = entry.getDescription();
            String content = null;
            if (syndContent != null) {
                content = syndContent.getValue();
            }
            if (content == null) {
                content = url;
            }
            Description desc = new Description(content);
            args.add((Property)desc);
            events.add((Object)event);
        }
        return calendar;
    }

    private static final SyndEntry[] getFeedEntries(SyndFeed feed) {
        List list = feed.getEntries();
        SyndEntry[] entries = new SyndEntry[list.size()];
        list.toArray(entries);
        return entries;
    }

    public static final SyndFeed parseFeed(byte[] feedBytes) {
        SyndFeed synFeed = null;
        try {
            SyndFeedInput input2 = new SyndFeedInput();
            XmlReader xmlReader = new XmlReader((InputStream)new ByteArrayInputStream(feedBytes));
            synFeed = input2.build((Reader)xmlReader);
        }
        catch (Exception e) {
            SilverLogger.getLogger(FeedUtilities.class).error((Throwable)e);
        }
        return synFeed;
    }
}

