/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.calendar.CalendarDay;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class CalendarDateTime
extends CalendarDay {
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    protected CalendarDateTime(Date date, String locale) {
        super(date, locale);
        Calendar calendar = DateUtil.convert((Date)date);
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.milliseconds = calendar.get(14);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public Date getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.getYear());
        calendar.set(2, this.getMonth());
        calendar.set(5, this.getDayOfMonth());
        calendar.set(11, this.hours);
        calendar.set(12, this.minutes);
        calendar.set(13, this.seconds);
        calendar.set(14, this.milliseconds);
        return calendar.getTime();
    }
}

