/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.ComponentInstanceCalendars;
import org.silverpeas.core.web.calendar.AbstractCalendarWebController;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceEntity;
import org.silverpeas.core.webapi.calendar.CalendarResourceURIs;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractCalendarWebRequestContext<T extends AbstractCalendarWebController>
extends WebComponentRequestContext<T> {
    private ComponentInstanceCalendars componentInstanceCalendars;
    private CalendarResourceURIs uri;

    @Override
    public void beforeRequestProcessing() {
        this.setComponentInstanceCalendars(Calendar.getByComponentInstanceId((String)this.getComponentInstanceId()));
    }

    protected ComponentInstanceCalendars getComponentInstanceCalendars() {
        return this.componentInstanceCalendars;
    }

    protected void setComponentInstanceCalendars(ComponentInstanceCalendars componentInstanceCalendars) {
        this.componentInstanceCalendars = componentInstanceCalendars;
    }

    public CalendarResourceURIs uri() {
        if (this.uri == null) {
            this.uri = CalendarResourceURIs.get();
        }
        return this.uri;
    }

    public Calendar getMainCalendar() {
        return (Calendar)this.getComponentInstanceCalendars().getMainCalendar().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
    }

    public Temporal getOccurrenceStartDate() {
        String startDate = this.getRequest().getParameter("occurrenceStartDate");
        if (StringUtil.isDefined((String)startDate)) {
            if (startDate.contains("T")) {
                return OffsetDateTime.parse(startDate);
            }
            return LocalDate.parse(startDate);
        }
        return null;
    }

    public CalendarEventOccurrence getCalendarEventOccurrenceById() {
        String occurrenceId = this.getPathVariables().get("occurrenceId");
        return AbstractCalendarWebRequestContext.getCalendarEventOccurrence(occurrenceId);
    }

    static CalendarEventOccurrence getCalendarEventOccurrence(String occurrenceId) {
        String decodedId;
        CalendarEventOccurrence event = null;
        if (StringUtil.isDefined((String)occurrenceId) && (event = (CalendarEventOccurrence)CalendarEventOccurrence.getById((String)(decodedId = CalendarEventOccurrenceEntity.decodeId(occurrenceId))).orElse(null)) == null) {
            throw new WebApplicationException(SilverpeasExceptionMessages.unknown((String)"calendar", (Object)decodedId), Response.Status.NOT_FOUND);
        }
        return event;
    }
}

