/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationService;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordException;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.core.security.authentication.password.service.PasswordRulesServiceProvider;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;

@Service
public class ResetPasswordHandler
extends CredentialsFunctionHandler {
    private static final String USER_ID_LOG_DATA = "userId=";
    private static final String LOG_CONTEXT = "CredentialsServlet.resetPasswordHandler.doAction()";
    @Inject
    private AuthenticationService authenticator;

    @Override
    public String getFunction() {
        return "ResetPassword";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String userId;
        String authenticationKey = request.getParameter("key");
        try {
            userId = this.getAdminService().getUserIdByAuthenticationKey(authenticationKey);
        }
        catch (Exception e) {
            return this.getGeneral().getString("forgottenPasswordResetError");
        }
        try {
            if (userId != null) {
                String password = PasswordRulesServiceProvider.getPasswordRulesService().generate();
                ForgottenPasswordMailParameters parameters = this.initializeParameters(userId);
                UserFull user = this.getUserFull(request, userId);
                this.resetPassword(userId, password, user);
                parameters.setPassword(password);
                parameters.setLink(this.getContextPath(request) + "/ResetLoginPassword?login=" + user.getLogin() + "&domainId=" + user.getDomainId());
                this.getForgottenPasswordMailManager().sendNewPasswordMail(parameters);
                return this.getGeneral().getString("forgottenPasswordReset");
            }
            return this.getGeneral().getString("forgottenPasswordResetError");
        }
        catch (ForgottenPasswordException fpe) {
            return this.forgottenPasswordError(request, fpe);
        }
    }

    private ForgottenPasswordMailParameters initializeParameters(String userId) throws ForgottenPasswordException {
        ForgottenPasswordMailParameters parameters;
        try {
            parameters = this.getMailParameters(userId);
        }
        catch (AdminException e) {
            throw new ForgottenPasswordException(LOG_CONTEXT, "forgottenPassword.EX_GET_USER_DETAIL", USER_ID_LOG_DATA + userId, (Exception)((Object)e));
        }
        return parameters;
    }

    private UserFull getUserFull(HttpServletRequest request, String userId) throws ForgottenPasswordException {
        UserFull user;
        try {
            user = this.getAdminService().getUserFull(userId);
            request.setAttribute("userLanguage", (Object)user.getUserPreferences().getLanguage());
        }
        catch (AdminException e) {
            throw new ForgottenPasswordException(LOG_CONTEXT, "forgottenPassword.EX_GET_FULL_USER_DETAIL", USER_ID_LOG_DATA + userId, (Exception)((Object)e));
        }
        return user;
    }

    private void resetPassword(String userId, String password, UserFull user) throws ForgottenPasswordException {
        try {
            AuthenticationCredential credential = AuthenticationCredential.newWithAsLogin((String)user.getLogin()).withAsDomainId(user.getDomainId());
            this.authenticator.resetPassword(credential, password);
        }
        catch (AuthenticationException e) {
            throw new ForgottenPasswordException(LOG_CONTEXT, "forgottenPassword.EX_RESET_PASSWORD_FAILED", USER_ID_LOG_DATA + userId, (Exception)((Object)e));
        }
    }
}

