/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandlerRegistering;
import org.silverpeas.core.web.authentication.credentials.RegistrationSettings;

@Service
public class NewRegistrationHandler
extends CredentialsFunctionHandler {
    private final RegistrationSettings settings = RegistrationSettings.getSettings();
    @Inject
    private PublicationTemplateManager publicationTemplateManager;

    @Override
    public String getFunction() {
        return "NewRegistration";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String destination = "";
        this.renewSecurityToken(request);
        if (this.settings.isUserSelfRegistrationEnabled()) {
            PagesContext context = new PagesContext();
            context.setDomainId(this.settings.userSelfRegistrationDomainId());
            PublicationTemplate template = this.publicationTemplateManager.getDirectoryTemplate(context);
            request.setAttribute("ExtraTemplate", (Object)template);
            destination = "/admin/jsp/newRegistration.jsp";
        }
        return destination;
    }

    @Override
    public void registerWith(HttpFunctionHandlerRegistering registering) {
        registering.register(this, true);
    }
}

