/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.invoker.util;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.invoker.ResponseProperties;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class InvokerUtil {
    public static String MARKUP_HEADERS = "com.sun.portal.portletcontainer.markupHeaders";
    private static Logger logger = ContainerLogger.getLogger(InvokerUtil.class, (String)"org.silverpeas.portlets.PCCTXLogMessages");

    public static void setResponseProperties(HttpServletRequest request, HttpServletResponse response, ResponseProperties responseProperties) {
        if (responseProperties != null) {
            List<Cookie> cookies = responseProperties.getCookies();
            for (Cookie cookie : cookies) {
                response.addCookie(cookie);
            }
            Map<String, List<String>> responseHeaders = responseProperties.getResponseHeaders();
            Set<Map.Entry<String, List<String>>> entries = responseHeaders.entrySet();
            for (Map.Entry<String, List<String>> mapEntry : entries) {
                String headerName = mapEntry.getKey();
                for (String headerValue : mapEntry.getValue()) {
                    response.addHeader(headerName, headerValue);
                }
            }
            HttpSession session = request.getSession(true);
            session.removeAttribute(MARKUP_HEADERS);
            List<Element> markupHeadElements = responseProperties.getMarkupHeadElements();
            if (!markupHeadElements.isEmpty()) {
                ArrayList<String> markupHeaders = new ArrayList<String>();
                for (Element markupHeadElement : markupHeadElements) {
                    String elementValue = InvokerUtil.convertElementToString(markupHeadElement);
                    if (elementValue == null) continue;
                    markupHeaders.add(elementValue);
                }
                session.setAttribute(MARKUP_HEADERS, markupHeaders);
            }
        }
    }

    public static void clearResponseProperties(ResponseProperties responseProperties) {
        if (responseProperties != null) {
            responseProperties.clear();
        }
    }

    private static String convertElementToString(Element element) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(element), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "PSPCD_CSPPD0010", ex.toString());
            }
            return null;
        }
    }
}

