/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.context.registry;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class PortletRegistryException
extends Exception {
    public static final String RESOURCE_BASE = "org.silverpeas.portlets.multilang.PortletRegistry";
    static Locale locale = Locale.getDefault();
    private static final long serialVersionUID = 7738268731991950804L;
    protected Throwable originalException = null;
    protected String key = null;
    protected Object[] tokens = null;

    public PortletRegistryException(String key) {
        super(key);
        this.key = key;
    }

    public PortletRegistryException(String key, Object[] tokens) {
        super(key);
        this.key = key;
        this.tokens = tokens != null ? (Object[])tokens.clone() : null;
    }

    public PortletRegistryException(String key, Throwable t) {
        super(key);
        this.originalException = t;
        this.key = key;
    }

    public PortletRegistryException(String key, Throwable t, Object[] tokens) {
        super(key);
        this.originalException = t;
        this.key = key;
        this.tokens = tokens != null ? (Object[])tokens.clone() : null;
    }

    public PortletRegistryException(Throwable t) {
        super(t);
        this.key = "";
        this.originalException = t;
    }

    public static void setLocale(Locale loc) {
        locale = loc;
    }

    @Override
    public String getMessage() {
        LocalizationBundle rb = ResourceLocator.getLocalizationBundle((String)RESOURCE_BASE);
        return this.getMessageFromRB((ResourceBundle)rb, this.key, this.tokens);
    }

    public Throwable getWrapped() {
        return this.originalException;
    }

    public String getWrappedMessage() {
        String msg = this.originalException != null ? this.originalException.getMessage() : null;
        return msg;
    }

    @Override
    public String getLocalizedMessage() {
        String msg;
        LocalizationBundle rb = ResourceLocator.getLocalizationBundle((String)RESOURCE_BASE, (String)locale.getLanguage());
        try {
            msg = this.getMessageFromRB((ResourceBundle)rb, this.key, this.tokens);
        }
        catch (MissingResourceException mrex) {
            msg = this.key;
        }
        return msg;
    }

    private String getMessageFromRB(ResourceBundle rb, String key, Object[] tokens) throws MissingResourceException {
        String message;
        try {
            String msg = rb.getString(key);
            if (tokens != null && tokens.length > 0) {
                MessageFormat mf = new MessageFormat("");
                mf.setLocale(rb.getLocale());
                mf.applyPattern(msg);
                message = mf.format(tokens);
            } else {
                message = msg;
            }
        }
        catch (MissingResourceException mrex) {
            message = key;
        }
        return message;
    }

    @Override
    public void printStackTrace() {
        if (this.originalException != null) {
            this.originalException.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.originalException != null) {
            this.originalException.printStackTrace(pw);
        } else {
            super.printStackTrace(pw);
        }
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getTokens() {
        return this.tokens;
    }
}

