/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;
import org.apache.jackrabbit.oak.segment.standby.server.ClientFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientFilterHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ClientFilterHandler.class);
    private final ClientFilter filter;

    ClientFilterHandler(ClientFilter filter) {
        this.filter = filter;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress address = ctx.channel().remoteAddress();
        if (this.filter.isAllowed(address)) {
            log.debug("Client {} is allowed", (Object)address);
            ctx.fireChannelActive();
        } else {
            log.debug("Client {} is rejected", (Object)address);
            ctx.close();
        }
    }
}

