/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.SegmentEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.jetbrains.annotations.NotNull;

class ReferencesNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String segmentId;

    ReferencesNode(Proc.Backend backend, String segmentId) {
        this.backend = backend;
        this.segmentId = segmentId;
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return this.backend.getSegmentReferences(this.segmentId).map(this::getChildNodeEntries).orElse(Collections.emptyList());
    }

    private Iterable<ChildNodeEntry> getChildNodeEntries(Iterable<String> references) {
        return StreamSupport.stream(references.spliterator(), false).map(this::newSegmentNodeEntry).collect(Collectors.toList());
    }

    private ChildNodeEntry newSegmentNodeEntry(String segmentId) {
        return new SegmentEntry(this.backend, segmentId);
    }
}

