/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SafeRunnable.class);
    @NotNull
    private final String name;
    @NotNull
    private final Runnable runnable;

    SafeRunnable(@NotNull String name, @NotNull Runnable runnable) {
        this.name = Objects.requireNonNull(name);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public void run() {
        try {
            String n = Thread.currentThread().getName();
            Thread.currentThread().setName(this.name);
            try {
                this.runnable.run();
            }
            finally {
                Thread.currentThread().setName(n);
            }
        }
        catch (Throwable e) {
            log.error(String.format("Uncaught exception in %s", this.name), e);
        }
    }
}

