/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service.caching;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletCacheEntry
implements Serializable {
    private int type;
    private StringBuffer content;
    private String titleResource;
    private Map<String, List<Element>> elementProperties;
    private Map<String, List<String>> stringProperties;
    private long expirationTime;
    private String eTag;
    private String localeString;
    private boolean needsValidation;

    public PortletCacheEntry(int cacheType, StringBuffer cachedContent, String titleResource, Map<String, List<Element>> elementProperties, Map<String, List<String>> stringProperties, int expiration, String eTag, String localeString) {
        this.type = cacheType;
        this.content = cachedContent;
        this.titleResource = titleResource;
        this.elementProperties = elementProperties;
        this.stringProperties = stringProperties;
        this.setExpirationTime(expiration);
        this.setETag(eTag);
        this.localeString = localeString;
    }

    public int getCacheType() {
        return this.type;
    }

    public StringBuffer getCachedContent() {
        return this.content;
    }

    public String getTitleResource() {
        return this.titleResource;
    }

    public Map<String, List<Element>> getElementProperties() {
        return this.elementProperties;
    }

    public Map<String, List<String>> getStringProperties() {
        return this.stringProperties;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public void setExpirationTime(int expiration) {
        this.expirationTime = expiration == -1 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)expiration * 1000L;
    }

    public void setNeedsValidation(boolean needsValidation) {
        this.needsValidation = needsValidation;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public String getLocaleString() {
        return this.localeString;
    }
}

