/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.social.oauth2.OAuth2RequestInterceptor;
import org.springframework.social.oauth2.OAuth2TokenParameterRequestInterceptor;
import org.springframework.social.oauth2.OAuth2Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TokenStrategy {
    AUTHORIZATION_HEADER{

        public ClientHttpRequestInterceptor interceptor(String accessToken, OAuth2Version oauth2Version) {
            return new OAuth2RequestInterceptor(accessToken, oauth2Version);
        }
    }
    ,
    ACCESS_TOKEN_PARAMETER{

        public ClientHttpRequestInterceptor interceptor(String accessToken, OAuth2Version oauth2Version) {
            return new OAuth2TokenParameterRequestInterceptor(accessToken);
        }
    }
    ,
    OAUTH_TOKEN_PARAMETER{

        public ClientHttpRequestInterceptor interceptor(String accessToken, OAuth2Version oauth2Version) {
            return new OAuth2TokenParameterRequestInterceptor(accessToken, "oauth_token");
        }
    };


    abstract ClientHttpRequestInterceptor interceptor(String var1, OAuth2Version var2);
}

