/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.security;

import java.security.Principal;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasTreePermission;
import org.silverpeas.core.jcr.security.AccessContext;
import org.silverpeas.core.jcr.security.SilverpeasUserPrincipal;

public class SilverpeasPermissionProvider
implements PermissionProvider {
    private final User user;
    private final Root root;
    private final ProviderCtx providerCtx;
    private final AccessContext accessContext;
    private Root readOnlyRoot;

    SilverpeasPermissionProvider(@Nonnull Root root, @Nonnull Set<Principal> principals, @Nonnull ProviderCtx providerCtx) {
        SilverpeasUserPrincipal principal = principals.stream().filter(Objects::nonNull).filter(SilverpeasUserPrincipal.class::isInstance).map(SilverpeasUserPrincipal.class::cast).findFirst().orElseGet(() -> principals.stream().filter(Objects::nonNull).filter(this::isSystemOrAdminPrincipal).findFirst().map(p -> new SilverpeasUserPrincipal(User.getSystemUser())).orElseThrow(() -> new IllegalArgumentException("No principals refer a user in Silverpeas")));
        this.user = principal.getUser();
        this.accessContext = principal.getAccessContext();
        this.root = root;
        this.providerCtx = providerCtx;
        this.readOnlyRoot = this.providerCtx.getRootProvider().createReadOnlyRoot(root);
    }

    public void refresh() {
        this.readOnlyRoot = this.providerCtx.getRootProvider().createReadOnlyRoot(this.root);
    }

    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        if (tree == null || this.user == null) {
            return Set.of();
        }
        if (this.isSystemOrAdminAccess()) {
            return Set.of("jcr:all");
        }
        return Set.of("jcr:read");
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        if (this.isSystemOrAdminAccess()) {
            return true;
        }
        if (privilegeNames.length == 1) {
            return privilegeNames[0].equals("jcr:read");
        }
        return false;
    }

    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.isSystemOrAdminAccess() ? RepositoryPermission.ALL : RepositoryPermission.EMPTY;
    }

    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        Tree readOnlyTree = PermissionUtil.getReadOnlyTree((Tree)tree, (Root)this.readOnlyRoot);
        return new SilverpeasTreePermission(readOnlyTree, this.user, this.accessContext);
    }

    public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        TreePermission treePermission = this.getTreePermission(tree, TreePermission.NO_RECOURSE);
        return property == null ? treePermission.isGranted(permissions) : treePermission.isGranted(permissions, property);
    }

    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        if (this.user.isSystem()) {
            return true;
        }
        TreeLocation location = TreeLocation.create((Root)this.readOnlyRoot, (String)oakPath);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)false);
        return this.isGranted(location, permissions);
    }

    private boolean isSystemOrAdminAccess() {
        return this.user.isSystem() || this.user.isAccessAdmin();
    }

    private boolean isSystemOrAdminPrincipal(Principal principal) {
        return principal instanceof SystemPrincipal || principal instanceof SystemUserPrincipal || principal instanceof AdminPrincipal;
    }

    private boolean isGranted(@Nonnull TreeLocation location, long permissions) {
        PropertyState property = location.getProperty();
        Tree tree = property == null ? location.getTree() : location.getParent().getTree();
        boolean isGranted = tree != null ? this.isGranted(tree, property, permissions) : false;
        return isGranted;
    }
}

