/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.factories;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.silverpeas.core.jcr.impl.ResourcesCloser;
import org.silverpeas.core.jcr.impl.oak.configuration.OakRepositoryConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.SegmentNodeStoreConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.StorageType;
import org.silverpeas.core.jcr.impl.oak.factories.GCLogger;
import org.silverpeas.core.jcr.impl.oak.factories.NodeStoreFactory;
import org.silverpeas.core.jcr.impl.oak.factories.SegmentNodeStoreCleaner;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public class SegmentNodeStoreFactory
implements NodeStoreFactory {
    @Override
    public NodeStore create(String jcrHomePath, OakRepositoryConfiguration conf) {
        FileStore fs;
        if (conf.getStorageType() != StorageType.SEGMENT_NODE_STORE && conf.getStorageType() != StorageType.COMPOSITE_NODE_STORE) {
            return null;
        }
        SegmentNodeStoreConfiguration parameters = conf.getSegmentNodeStoreConfiguration();
        Path storagePath = Path.of(parameters.getStoragePath(), new String[0]);
        Path segmentStore = storagePath.isAbsolute() ? storagePath : Path.of(jcrHomePath, new String[0]).resolve(storagePath);
        try {
            fs = FileStoreBuilder.fileStoreBuilder((File)segmentStore.toFile()).withMaxFileSize(parameters.getTarMaxSize()).withSegmentCacheSize(parameters.getSegmentCacheSize()).withStringCacheSize(parameters.getStringCacheSize()).withTemplateCacheSize(parameters.getTemplateCacheSize()).withStringDeduplicationCacheSize(parameters.getStringDeduplicationCacheSize()).withTemplateDeduplicationCacheSize(parameters.getTemplateDeduplicationCacheSize()).withNodeDeduplicationCacheSize(parameters.getNodeDeduplicationCacheSize()).withGCOptions(SegmentGCOptions.defaultGCOptions().setPaused(parameters.isPauseCompaction()).setRetryCount(parameters.getCompactionRetryCount()).setForceTimeout(parameters.getCompactionForceTimeout()).setGcSizeDeltaEstimation(parameters.getCompactionSizeDeltaEstimation()).setEstimationDisabled(parameters.isCompactionDisableEstimation()).setMemoryThreshold(parameters.getCompactionMemoryThreshold()).setGCLogInterval(parameters.getCompactionProgressLog())).withGCMonitor((GCMonitor)new GCLogger()).build();
            this.initializeCompaction(segmentStore, fs, parameters);
            ResourcesCloser.get().register((Closeable)fs);
        }
        catch (IOException | ParseException | InvalidFileStoreVersionException e) {
            throw new SilverpeasRuntimeException(e);
        }
        return SegmentNodeStoreBuilders.builder((FileStore)fs).build();
    }

    private void initializeCompaction(Path segmentStore, FileStore fs, SegmentNodeStoreConfiguration parameters) throws ParseException {
        if (!parameters.isPauseCompaction()) {
            SegmentNodeStoreCleaner cleaner = SegmentNodeStoreCleaner.get();
            try {
                cleaner.initializeWith(segmentStore, fs, parameters);
                cleaner.execute();
            }
            catch (SilverpeasException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }
}

