/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.factories;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.silverpeas.core.jcr.impl.ResourcesCloser;
import org.silverpeas.core.jcr.impl.oak.configuration.DocumentNodeStoreConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.OakRepositoryConfiguration;
import org.silverpeas.core.jcr.impl.oak.configuration.StorageType;
import org.silverpeas.core.jcr.impl.oak.factories.NodeStoreFactory;
import org.silverpeas.kernel.exception.NotSupportedException;

public class DocumentNodeStoreFactory
implements NodeStoreFactory {
    private final Map<DocumentNodeStoreConfiguration.DocumentStoreType, Function<DocumentNodeStoreConfiguration, DocumentNodeStore>> nodeStoreBuilders = Map.of(DocumentNodeStoreConfiguration.DocumentStoreType.MONGO, this::createMongoNodeStore, DocumentNodeStoreConfiguration.DocumentStoreType.RDB, c -> {
        throw new NotSupportedException("The relational database backend isn't currently supported as document-based datasource");
    });

    @Override
    public NodeStore create(String jcrHomePath, OakRepositoryConfiguration conf) {
        if (conf.getStorageType() != StorageType.DOCUMENT_NODE_STORE && conf.getStorageType() != StorageType.COMPOSITE_NODE_STORE) {
            return null;
        }
        DocumentNodeStoreConfiguration docNodeConf = conf.getDocumentNodeStoreConfiguration();
        return (NodeStore)this.nodeStoreBuilders.getOrDefault((Object)docNodeConf.getDocumentStoreType(), c -> null).apply(docNodeConf);
    }

    private DocumentNodeStore createMongoNodeStore(DocumentNodeStoreConfiguration conf) {
        DocumentNodeStoreBuilder builder = ((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)MongoDocumentNodeStoreBuilder.newMongoDocumentNodeStoreBuilder().setExecutor((Executor)MoreExecutors.newDirectExecutorService())).setMongoDB(conf.getUri(), conf.getDBName(), conf.getBlobCacheSize())).setSocketKeepAlive(conf.getSocketKeepAlive())).memoryCacheSize((long)conf.getCacheSize())).memoryCacheDistribution(conf.getNodeCachePercentage(), conf.getPrevDocCachePercentage(), conf.getChildrenCachePercentage(), conf.getDiffCachePercentage(), 1)).setCacheSegmentCount(conf.getCacheSegmentCount())).setCacheStackMoveDistance(conf.getCacheStackMoveDistance())).setMaxReplicationLag((long)conf.getMaxReplicationLag(), TimeUnit.SECONDS)).setJournalGCMaxAge(conf.getJournalGCMaxAge())).setRevisionGCMaxAge((long)conf.getVersionGCMaxAge())).setLeaseCheckMode(LeaseCheckMode.valueOf((String)conf.getLeaseCheckMode()))).setNodeCachePathPredicate(this.createCachePredicate(conf))).setUpdateLimit(conf.getUpdateNbLimit());
        DocumentNodeStore store = builder.build();
        ResourcesCloser.get().register(() -> ((DocumentNodeStore)store).dispose());
        return store;
    }

    private Predicate<Path> createCachePredicate(DocumentNodeStoreConfiguration config) {
        List<String> subtrees = config.getSubtreesInPersistentCache();
        if (subtrees.isEmpty()) {
            return Predicates.alwaysTrue();
        }
        if (subtrees.contains("/")) {
            return Predicates.alwaysTrue();
        }
        List subtreePaths = subtrees.stream().filter(Objects::nonNull).map(String::trim).map(Path::fromString).collect(Collectors.toList());
        return p -> p != null && subtreePaths.stream().anyMatch(subtree -> subtree.isAncestorOf(p));
    }
}

