/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak.configuration;

import java.util.List;
import java.util.Properties;
import org.silverpeas.core.jcr.impl.oak.configuration.NodeStoreConfiguration;

public class DocumentNodeStoreConfiguration
extends NodeStoreConfiguration {
    public String getUri() {
        return this.getString("document.uri", "mongodb://localhost:27017");
    }

    public String getDBName() {
        return this.getString("document.db", "oak");
    }

    public boolean getSocketKeepAlive() {
        return this.getBoolean("document.socketKeepAlive", true);
    }

    public int getCacheSize() {
        return this.getInteger("document.cache", 256);
    }

    public int getMaxReplicationLag() {
        return this.getInteger("document.maxReplicationLagInSecs", 21600);
    }

    public int getVersionGCMaxAge() {
        return this.getInteger("document.versionGCMaxAgeInSecs", 86400);
    }

    public long getJournalGCMaxAge() {
        return this.getLong("document.journalGCMaxAge", 86400000L);
    }

    public int getBlobCacheSize() {
        return this.getInteger("document.blobCacheSize", 16);
    }

    public List<String> getSubtreesInPersistentCache() {
        return this.getList("document.persistentCacheIncludes", DefaultValues.PERSISTENT_CACHE_CONTENT);
    }

    public int getNodeCachePercentage() {
        return this.getInteger("document.nodeCachePercentage", 35);
    }

    public int getPrevDocCachePercentage() {
        return this.getInteger("document.prevDocCachePercentage", 4);
    }

    public int getChildrenCachePercentage() {
        return this.getInteger("document.childrenCachePercentage", 15);
    }

    public int getDiffCachePercentage() {
        return this.getInteger("document.diffCachePercentage", 30);
    }

    public int getCacheSegmentCount() {
        return this.getInteger("document.cacheSegmentCount", 16);
    }

    public int getCacheStackMoveDistance() {
        return this.getInteger("document.cacheStackMoveDistance", 16);
    }

    public int getUpdateNbLimit() {
        return this.getInteger("document.updateLimit", 100000);
    }

    public String getLeaseCheckMode() {
        return this.getString("document.leaseCheckMode", "STRICT");
    }

    public DocumentStoreType getDocumentStoreType() {
        return DocumentStoreType.valueOf(this.getString("document.storeType", DefaultValues.STORE_TYPE));
    }

    DocumentNodeStoreConfiguration(Properties props) {
        super(props);
    }

    public static enum DocumentStoreType {
        MONGO,
        RDB;


        public String toString() {
            String name = this.name();
            return name.charAt(0) + name.substring(1).toLowerCase();
        }
    }

    public static class DefaultValues {
        public static final String DB_URI = "mongodb://localhost:27017";
        public static final String DB_NAME = "oak";
        public static final boolean SOCKET_KEEP_ALIVE = true;
        public static final int CACHE_SIZE = 256;
        public static final int MAX_REPLICATION_LAG = 21600;
        public static final int VERSION_GC_MAX_AGE = 86400;
        public static final long JOURNAL_GC_MAX_AGE = 86400000L;
        public static final int BLOB_CACHE_SIZE = 16;
        public static final List<String> PERSISTENT_CACHE_CONTENT = List.of("/");
        public static final int NODE_CACHE_PERCENTAGE = 35;
        public static final int PREV_DOC_CACHE_PERCENTAGE = 4;
        public static final int CHILDREN_CACHE_PERCENTAGE = 15;
        public static final int DIFF_CACHE_PERCENTAGE = 30;
        public static final int CACHE_SEGMENT_COUNT = 16;
        public static final int CACHE_STACK_MOVE_DISTANCE = 16;
        public static final int UPDATE_COUNT_THRESHOLD = 100000;
        public static final String LEASE_CHECK_MODE = "STRICT";
        public static final String STORE_TYPE = DocumentStoreType.MONGO.name();

        private DefaultValues() {
        }
    }
}

