/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.impl.oak;

import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.silverpeas.core.jcr.SilverpeasRepository;
import org.silverpeas.core.jcr.impl.oak.security.SilverpeasSecurityProvider;

public class OakRepository
extends SilverpeasRepository {
    private final NodeStore nodeStore;

    static OakRepository create(NodeStore store) {
        if (store != null) {
            return new OakRepository(store);
        }
        return null;
    }

    private OakRepository(NodeStore nodeStore) {
        super(new Jcr(new Oak(nodeStore)).with((SecurityProvider)new SilverpeasSecurityProvider()).with("silverpeas").createRepository());
        this.nodeStore = nodeStore;
    }

    public void shutdown() {
        Repository repository = this.getRepository();
        if (repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)repository).shutdown();
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }
}

