/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import edu.psu.swe.scim.server.exception.UnableToCreateResourceException;
import edu.psu.swe.scim.server.exception.UnableToDeleteResourceException;
import edu.psu.swe.scim.server.exception.UnableToRetrieveResourceException;
import edu.psu.swe.scim.server.exception.UnableToUpdateResourceException;
import edu.psu.swe.scim.server.provider.Provider;
import edu.psu.swe.scim.server.provider.ProviderRegistry;
import edu.psu.swe.scim.server.provider.UpdateRequest;
import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.protocol.BulkResource;
import edu.psu.swe.scim.spec.protocol.data.BulkOperation;
import edu.psu.swe.scim.spec.protocol.data.BulkRequest;
import edu.psu.swe.scim.spec.protocol.data.BulkResponse;
import edu.psu.swe.scim.spec.protocol.data.ErrorResponse;
import edu.psu.swe.scim.spec.resources.BaseResource;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.Schema;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class BulkResourceImpl
implements BulkResource {
    private static final Logger log = LoggerFactory.getLogger(BulkResourceImpl.class);
    private static final String BULK_ID_DOES_NOT_EXIST = "Bulk ID cannot be resolved because it refers to no bulkId in any Bulk Operation: %s";
    private static final String BULK_ID_REFERS_TO_FAILED_RESOURCE = "Bulk ID cannot be resolved because the resource it refers to had failed to be created: %s";
    private static final String OPERATION_DEPENDS_ON_FAILED_OPERATION = "Operation depends on failed bulk operation: %s";
    private static final Pattern PATH_PATTERN = Pattern.compile("^/[^/]+/[^/]+$");
    @Inject
    Registry registry;
    @Inject
    ProviderRegistry providerRegistry;
    @Inject
    Instance<UpdateRequest<ScimResource>> updateRequestInstance;

    public Response doBulk(BulkRequest request, UriInfo uriInfo) {
        String bulkIdKey;
        int errorCount = 0;
        int requestFailOnErrors = request.getFailOnErrors();
        int maxErrorCount = requestFailOnErrors > 0 ? requestFailOnErrors : Integer.MAX_VALUE;
        int errorCountIncrement = requestFailOnErrors > 0 ? 1 : 0;
        List bulkOperations = request.getOperations();
        HashMap<String, BulkOperation> bulkIdKeyToOperationResult = new HashMap<String, BulkOperation>();
        ArrayList<IWishJavaHadTuples> allUnresolveds = new ArrayList<IWishJavaHadTuples>();
        Map<String, Set<String>> reverseDependenciesGraph = this.generateReverseDependenciesGraph(bulkOperations);
        Map<String, Set<String>> transitiveReverseDependencies = BulkResourceImpl.generateTransitiveDependenciesGraph(reverseDependenciesGraph);
        log.debug("Reverse dependencies: {}", reverseDependenciesGraph);
        log.debug("Transitive reverse dependencies: {}", transitiveReverseDependencies);
        for (BulkOperation operationRequest : bulkOperations) {
            operationRequest.setResponse(null);
            operationRequest.setStatus(null);
        }
        for (BulkOperation operationRequest : bulkOperations) {
            boolean errorOccurred;
            String bulkIdKey2;
            block29: {
                BulkOperation.Method method;
                block28: {
                    String bulkId = operationRequest.getBulkId();
                    method = operationRequest.getMethod();
                    bulkIdKey2 = bulkId != null ? "bulkId:" + bulkId : null;
                    errorOccurred = false;
                    if (bulkIdKey2 != null) {
                        if (!bulkIdKeyToOperationResult.containsKey(bulkIdKey2)) {
                            bulkIdKeyToOperationResult.put(bulkIdKey2, operationRequest);
                        } else {
                            errorOccurred = true;
                            BulkOperation duplicateOperation = (BulkOperation)bulkIdKeyToOperationResult.get(bulkIdKey2);
                            BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.CONFLICT, "Duplicate bulkId");
                            if (!(duplicateOperation.getResponse() instanceof ErrorResponse)) {
                                duplicateOperation.setData(null);
                                BulkResourceImpl.createAndSetErrorResponse(duplicateOperation, Response.Status.CONFLICT, "Duplicate bulkId");
                            }
                        }
                    }
                    if (method == null || operationRequest.getResponse() instanceof ErrorResponse) break block28;
                    switch (method) {
                        case POST: 
                        case PUT: {
                            if (operationRequest.getData() == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.BAD_REQUEST, "data not provided");
                                break;
                            }
                            break block29;
                        }
                        case DELETE: {
                            String path = operationRequest.getPath();
                            if (path == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.BAD_REQUEST, "path not provided");
                                break;
                            }
                            if (!PATH_PATTERN.matcher(path).matches()) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.BAD_REQUEST, "path is not a valid path (e.g. \"/Groups/123abc\", \"/Users/123xyz\", ...)");
                                break;
                            }
                            String endPoint = path.substring(0, path.lastIndexOf(47));
                            Class clazz = this.registry.findScimResourceClassFromEndpoint(endPoint);
                            if (clazz == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.BAD_REQUEST, "path does not contain a recognized endpoint (e.g. \"/Groups/...\", \"/Users/...\", ...)");
                                break;
                            }
                            break block29;
                        }
                        case PATCH: {
                            errorOccurred = true;
                            BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.NOT_IMPLEMENTED, "Method not implemented: PATCH");
                            break;
                        }
                    }
                    break block29;
                }
                if (method == null) {
                    errorOccurred = true;
                    operationRequest.setData(null);
                    BulkResourceImpl.createAndSetErrorResponse(operationRequest, Response.Status.BAD_REQUEST, "no method provided (e.g. PUT, POST, ...");
                }
            }
            if (!errorOccurred) continue;
            operationRequest.setData(null);
            if (bulkIdKey2 == null) continue;
            Set<String> reverseDependencies = transitiveReverseDependencies.get(bulkIdKey2);
            String detail = String.format(OPERATION_DEPENDS_ON_FAILED_OPERATION, bulkIdKey2);
            for (String dependentBulkIdKey : reverseDependencies) {
                BulkOperation dependentOperation = (BulkOperation)bulkIdKeyToOperationResult.get(dependentBulkIdKey);
                if (dependentOperation.getResponse() instanceof ErrorResponse) continue;
                dependentOperation.setData(null);
                BulkResourceImpl.createAndSetErrorResponse(dependentOperation, Response.Status.CONFLICT, detail);
            }
        }
        for (BulkOperation operationResult : bulkOperations) {
            boolean errorCountExceeded;
            boolean bl = errorCountExceeded = errorCount >= maxErrorCount;
            if (!errorCountExceeded && !(operationResult.getResponse() instanceof ErrorResponse)) {
                String detail;
                try {
                    this.handleBulkOperationMethod(allUnresolveds, operationResult, bulkIdKeyToOperationResult, uriInfo);
                }
                catch (UnableToCreateResourceException | UnableToDeleteResourceException | UnableToUpdateResourceException resourceException) {
                    log.error("Failed to do bulk operation", (Throwable)resourceException);
                    errorCount += errorCountIncrement;
                    detail = resourceException.getLocalizedMessage();
                    Response.Status status = resourceException instanceof UnableToCreateResourceException ? ((UnableToCreateResourceException)resourceException).getStatus() : (resourceException instanceof UnableToDeleteResourceException ? ((UnableToDeleteResourceException)resourceException).getStatus() : ((UnableToUpdateResourceException)resourceException).getStatus());
                    BulkResourceImpl.createAndSetErrorResponse(operationResult, status, detail);
                    if (operationResult.getBulkId() == null) continue;
                    String bulkIdKey3 = "bulkId:" + operationResult.getBulkId();
                    this.cleanup(bulkIdKey3, transitiveReverseDependencies, bulkIdKeyToOperationResult);
                }
                catch (UnresolvableOperationException unresolvableOperationException) {
                    log.error("Could not resolve bulkId during Bulk Operation method handling", (Throwable)unresolvableOperationException);
                    errorCount += errorCountIncrement;
                    detail = unresolvableOperationException.getLocalizedMessage();
                    BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.CONFLICT, detail);
                    if (operationResult.getBulkId() == null) continue;
                    String bulkIdKey4 = "bulkId:" + operationResult.getBulkId();
                    this.cleanup(bulkIdKey4, transitiveReverseDependencies, bulkIdKeyToOperationResult);
                }
                continue;
            }
            if (!errorCountExceeded) continue;
            BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.CONFLICT, "failOnErrors count reached");
            if (operationResult.getBulkId() == null) continue;
            bulkIdKey = "bulkId:" + operationResult.getBulkId();
            this.cleanup(bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
        }
        for (IWishJavaHadTuples iwjht : allUnresolveds) {
            String detail;
            BulkOperation bulkOperationResult = iwjht.bulkOperationResult;
            bulkIdKey = iwjht.bulkIdKey;
            ScimResource scimResource = bulkOperationResult.getData();
            try {
                for (UnresolvedTopLevel unresolved : iwjht.unresolveds) {
                    log.debug("Final resolution pass for {}", (Object)unresolved);
                    unresolved.resolve(scimResource, bulkIdKeyToOperationResult);
                }
                String scimResourceId = scimResource.getId();
                Class<?> scimResourceClass = scimResource.getClass();
                Provider<?> provider = this.providerRegistry.getProvider(scimResourceClass);
                Object original = provider.get(scimResourceId);
                UpdateRequest updateRequest = (UpdateRequest)this.updateRequestInstance.get();
                updateRequest.initWithResource(scimResourceId, original, scimResource);
                provider.update(updateRequest);
            }
            catch (UnresolvableOperationException unresolvableOperationException) {
                log.error("Could not complete final resolution pass, unresolvable bulkId", (Throwable)unresolvableOperationException);
                detail = unresolvableOperationException.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, Response.Status.CONFLICT, detail);
                this.cleanup(bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
            catch (UnableToUpdateResourceException unableToUpdateResourceException) {
                log.error("Failed to update Scim Resource with resolved bulkIds", (Throwable)unableToUpdateResourceException);
                detail = unableToUpdateResourceException.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, unableToUpdateResourceException.getStatus(), detail);
                this.cleanup(bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
            catch (UnableToRetrieveResourceException e) {
                log.error("Could not complete final resolution pass, unresolvable bulkId", (Throwable)e);
                detail = e.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, Response.Status.NOT_FOUND, detail);
                this.cleanup(bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
        }
        BulkResponse response = new BulkResponse();
        response.setOperations(bulkOperations);
        response.setStatus(Response.Status.OK);
        return Response.ok((Object)response).build();
    }

    private void cleanup(String bulkIdKeyToCleanup, Map<String, Set<String>> transitiveReverseDependencies, Map<String, BulkOperation> bulkIdKeyToOperationResult) {
        Set<String> reverseDependencies = transitiveReverseDependencies.get(bulkIdKeyToCleanup);
        BulkOperation operationResult = bulkIdKeyToOperationResult.get(bulkIdKeyToCleanup);
        String bulkId = operationResult.getBulkId();
        ScimResource scimResource = operationResult.getData();
        Class<?> scimResourceClass = scimResource.getClass();
        Provider<?> provider = this.providerRegistry.getProvider(scimResourceClass);
        try {
            provider.delete(scimResource.getId());
        }
        catch (UnableToDeleteResourceException unableToDeleteResourceException) {
            log.error("Could not delete ScimResource after failure: {}", (Object)scimResource);
        }
        for (String dependentBulkIdKey : reverseDependencies) {
            BulkOperation dependentOperationResult = bulkIdKeyToOperationResult.get(dependentBulkIdKey);
            if (dependentOperationResult.getResponse() instanceof ErrorResponse) continue;
            try {
                ScimResource dependentResource = dependentOperationResult.getData();
                String dependentResourceId = dependentResource.getId();
                Class<?> dependentResourceClass = dependentResource.getClass();
                Provider<?> dependentResourceProvider = this.providerRegistry.getProvider(dependentResourceClass);
                dependentOperationResult.setData(null);
                dependentOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(dependentOperationResult, Response.Status.CONFLICT, String.format(OPERATION_DEPENDS_ON_FAILED_OPERATION, bulkId, dependentBulkIdKey));
                dependentResourceProvider.delete(dependentResourceId);
            }
            catch (UnableToDeleteResourceException unableToDeleteResourceException) {
                log.error("Could not delete depenedent ScimResource after failing to update dependee", (Throwable)unableToDeleteResourceException);
            }
        }
    }

    private void handleBulkOperationMethod(List<IWishJavaHadTuples> unresolveds, BulkOperation operationResult, Map<String, BulkOperation> bulkIdKeyToOperationResult, UriInfo uriInfo) throws UnableToCreateResourceException, UnableToDeleteResourceException, UnableToUpdateResourceException, UnresolvableOperationException {
        Class<Object> scimResourceClass;
        ScimResource scimResource = operationResult.getData();
        BulkOperation.Method bulkOperationMethod = operationResult.getMethod();
        String bulkId = operationResult.getBulkId();
        if (scimResource == null) {
            String path = operationResult.getPath();
            String endPoint = path.substring(0, path.lastIndexOf(47));
            Class clazz = this.registry.findScimResourceClassFromEndpoint(endPoint);
            scimResourceClass = clazz;
        } else {
            Class<?> clazz;
            scimResourceClass = clazz = scimResource.getClass();
        }
        Provider<?> provider = this.providerRegistry.getProvider(scimResourceClass);
        switch (bulkOperationMethod) {
            case POST: {
                log.debug("POST: {}", (Object)scimResource);
                this.resolveTopLevel(unresolveds, operationResult, bulkIdKeyToOperationResult);
                log.debug("Creating {}", (Object)scimResource);
                ScimResource newScimResource = provider.create(scimResource);
                String bulkOperationPath = operationResult.getPath();
                String newResourceId = newScimResource.getId();
                String newResourceUri = uriInfo.getBaseUriBuilder().path(bulkOperationPath).path(newResourceId).build(new Object[0]).toString();
                if (bulkId != null) {
                    String bulkIdKey = "bulkId:" + bulkId;
                    log.debug("adding {} = {}", (Object)bulkIdKey, (Object)newResourceId);
                    bulkIdKeyToOperationResult.get(bulkIdKey).setData(newScimResource);
                }
                operationResult.setData(newScimResource);
                operationResult.setLocation(newResourceUri.toString());
                operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.CREATED));
                break;
            }
            case DELETE: {
                log.debug("DELETE: {}", (Object)operationResult.getPath());
                String scimResourceId = operationResult.getPath().substring(operationResult.getPath().lastIndexOf("/") + 1);
                provider.delete(scimResourceId);
                operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.NO_CONTENT));
                break;
            }
            case PUT: {
                log.debug("PUT: {}", (Object)scimResource);
                this.resolveTopLevel(unresolveds, operationResult, bulkIdKeyToOperationResult);
                String id = operationResult.getPath().substring(operationResult.getPath().lastIndexOf("/") + 1);
                try {
                    Object original = provider.get(id);
                    UpdateRequest updateRequest = (UpdateRequest)this.updateRequestInstance.get();
                    updateRequest.initWithResource(id, original, scimResource);
                    provider.update(updateRequest);
                    operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.OK));
                }
                catch (UnableToRetrieveResourceException e) {
                    operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.NOT_FOUND));
                }
                break;
            }
            default: {
                BulkOperation.Method method = operationResult.getMethod();
                String detail = "Method not allowed: " + method;
                log.error("Received unallowed method: {}", (Object)method);
                BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.METHOD_NOT_ALLOWED, detail);
            }
        }
    }

    private static void createAndSetErrorResponse(BulkOperation operationResult, Response.Status status, String detail) {
        ErrorResponse error = new ErrorResponse(status, detail);
        operationResult.setResponse((BaseResource)error);
        operationResult.setStatus(new BulkOperation.StatusWrapper(status));
    }

    private static List<UnresolvedComplex> resolveAttribute(List<UnresolvedComplex> unresolveds, Object attributeValue, Schema.Attribute attribute, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
        if (attributeValue == null) {
            return unresolveds;
        }
        List attributes = attribute.getAttributes();
        for (Schema.Attribute subAttribute : attributes) {
            Field attributeField = subAttribute.getField();
            try {
                Object subFieldValue;
                if (subAttribute.isScimResourceIdReference()) {
                    String bulkIdKey = (String)attributeField.get(attributeValue);
                    if (bulkIdKey == null || !bulkIdKey.startsWith("bulkId:")) continue;
                    log.debug("Found bulkId: {}", (Object)bulkIdKey);
                    if (bulkIdKeyToOperationResult.containsKey(bulkIdKey)) {
                        BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(bulkIdKey);
                        BaseResource response = resolvedOperationResult.getResponse();
                        ScimResource resolvedResource = resolvedOperationResult.getData();
                        if (!(response != null && response instanceof ErrorResponse || resolvedResource == null || resolvedResource.getId() == null)) {
                            String resolvedId = resolvedResource.getId();
                            attributeField.set(attributeValue, resolvedId);
                            continue;
                        }
                        UnresolvedComplex unresolved = new UnresolvedComplex(attributeValue, attributeField, bulkIdKey);
                        unresolveds.add(unresolved);
                        continue;
                    }
                    throw new UnresolvableOperationException(String.format(BULK_ID_DOES_NOT_EXIST, bulkIdKey));
                }
                if (subAttribute.getType() != Schema.Attribute.Type.COMPLEX || (subFieldValue = attributeField.get(attributeValue)) == null) continue;
                Class<?> subFieldClass = subFieldValue.getClass();
                boolean isCollection = Collection.class.isAssignableFrom(subFieldClass);
                if (isCollection || subFieldClass.isArray()) {
                    List<Object> subFieldValues = isCollection ? (List<Object>)subFieldValue : Arrays.asList((Object[])subFieldValue);
                    for (Object e : subFieldValues) {
                        BulkResourceImpl.resolveAttribute(unresolveds, e, subAttribute, bulkIdKeyToOperationResult);
                    }
                    continue;
                }
                BulkResourceImpl.resolveAttribute(unresolveds, subFieldValue, subAttribute, bulkIdKeyToOperationResult);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Could not resolve bulkId within ScimResource attribute", (Throwable)illegalAccessException);
            }
        }
        log.debug("Resolved attribute had {} unresolved fields", (Object)unresolveds.size());
        return unresolveds;
    }

    private void resolveTopLevel(List<IWishJavaHadTuples> unresolveds, BulkOperation bulkOperationResult, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
        ScimResource scimResource = bulkOperationResult.getData();
        String schemaUrn = scimResource.getBaseUrn();
        Schema schema = this.registry.getSchema(schemaUrn);
        ArrayList<UnresolvedTopLevel> unresolvedTopLevels = new ArrayList<UnresolvedTopLevel>();
        for (Schema.Attribute attribute : schema.getAttributes()) {
            Field attributeField = attribute.getField();
            try {
                Object attributeFieldValue;
                UnresolvedTopLevel unresolved;
                if (attribute.isScimResourceIdReference()) {
                    String bulkIdKey = (String)attributeField.get(scimResource);
                    if (bulkIdKey == null || !bulkIdKey.startsWith("bulkId:")) continue;
                    if (bulkIdKeyToOperationResult.containsKey(bulkIdKey)) {
                        BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(bulkIdKey);
                        BaseResource response = resolvedOperationResult.getResponse();
                        ScimResource resolvedResource = resolvedOperationResult.getData();
                        if (!(response != null && response instanceof ErrorResponse || resolvedResource == null)) {
                            String resolvedId = resolvedResource.getId();
                            attributeField.set(scimResource, resolvedId);
                            continue;
                        }
                        unresolved = new UnresolvedTopLevelBulkId(attributeField, bulkIdKey);
                        attributeField.set(scimResource, null);
                        unresolvedTopLevels.add(unresolved);
                        continue;
                    }
                    throw new UnresolvableOperationException(String.format(BULK_ID_DOES_NOT_EXIST, bulkIdKey));
                }
                if (attribute.getType() != Schema.Attribute.Type.COMPLEX || (attributeFieldValue = attributeField.get(scimResource)) == null) continue;
                ArrayList<UnresolvedComplex> subUnresolveds = new ArrayList<UnresolvedComplex>();
                Class<?> subFieldClass = attributeFieldValue.getClass();
                boolean isCollection = Collection.class.isAssignableFrom(subFieldClass);
                if (isCollection || subFieldClass.isArray()) {
                    List<Object> subFieldValues = isCollection ? (List<Object>)attributeFieldValue : Arrays.asList((Object[])attributeFieldValue);
                    for (Object e : subFieldValues) {
                        BulkResourceImpl.resolveAttribute(subUnresolveds, e, attribute, bulkIdKeyToOperationResult);
                    }
                } else {
                    BulkResourceImpl.resolveAttribute(subUnresolveds, attributeFieldValue, attribute, bulkIdKeyToOperationResult);
                }
                if (subUnresolveds.size() <= 0) continue;
                unresolved = new UnresolvedTopLevelComplex(attributeField, attributeFieldValue, subUnresolveds);
                attributeField.set(scimResource, null);
                unresolvedTopLevels.add(unresolved);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Failed to access a ScimResource ID reference field to resolve it", (Throwable)illegalAccessException);
            }
        }
        if (unresolvedTopLevels.size() > 0) {
            String bulkIdKey = "bulkId:" + bulkOperationResult.getBulkId();
            unresolveds.add(new IWishJavaHadTuples(bulkIdKey, unresolvedTopLevels, bulkOperationResult));
        }
    }

    private static void generateVisited(Set<String> visited, Map<String, Set<String>> dependencyGraph, String root, String current) {
        if (!root.equals(current) && !visited.contains(current)) {
            visited.add(current);
            Set<String> dependencies = dependencyGraph.get(current);
            for (String dependency : dependencies) {
                BulkResourceImpl.generateVisited(visited, dependencyGraph, root, dependency);
            }
        }
    }

    private static Map<String, Set<String>> generateTransitiveDependenciesGraph(Map<String, Set<String>> dependenciesGraph) {
        HashMap<String, Set<String>> transitiveDependenciesGraph = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : dependenciesGraph.entrySet()) {
            String root = entry.getKey();
            Set<String> dependencies = entry.getValue();
            HashSet<String> visited = new HashSet<String>();
            transitiveDependenciesGraph.put(root, visited);
            for (String dependency : dependencies) {
                BulkResourceImpl.generateVisited(visited, dependenciesGraph, root, dependency);
            }
        }
        return transitiveDependenciesGraph;
    }

    private static void generateReverseDependenciesGraph(Map<String, Set<String>> reverseDependenciesGraph, String dependentBulkId, Object scimObject, List<Schema.Attribute> scimObjectAttributes) {
        for (Schema.Attribute scimObjectAttribute : scimObjectAttributes) {
            try {
                if (scimObjectAttribute.isScimResourceIdReference()) {
                    String reference = (String)scimObjectAttribute.getField().get(scimObject);
                    if (reference == null || !reference.startsWith("bulkId:")) continue;
                    Set dependents = reverseDependenciesGraph.computeIfAbsent(reference, unused -> new HashSet());
                    dependents.add("bulkId:" + dependentBulkId);
                    continue;
                }
                if (scimObjectAttribute.isMultiValued()) {
                    Object attributeObject = scimObjectAttribute.getField().get(scimObject);
                    Class<?> attributeObjectClass = attributeObject.getClass();
                    boolean isCollection = Collection.class.isAssignableFrom(attributeObjectClass);
                    List<Object> attributeValues = isCollection ? (List<Object>)attributeObject : Arrays.asList(attributeObject);
                    List subAttributes = scimObjectAttribute.getAttributes();
                    for (Object e : attributeValues) {
                        BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, dependentBulkId, e, subAttributes);
                    }
                    continue;
                }
                if (scimObjectAttribute.getType() != Schema.Attribute.Type.COMPLEX) continue;
                Object attributeValue = scimObjectAttribute.getField().get(scimObject);
                List subAttributes = scimObjectAttribute.getAttributes();
                BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, dependentBulkId, attributeValue, subAttributes);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Resolving reverse dependencies", (Throwable)illegalAccessException);
            }
        }
    }

    private Map<String, Set<String>> generateReverseDependenciesGraph(List<BulkOperation> bulkOperations) {
        HashMap<String, Set<String>> reverseDependenciesGraph = new HashMap<String, Set<String>>();
        for (BulkOperation bulkOperation : bulkOperations) {
            String bulkId = bulkOperation.getBulkId();
            if (bulkId == null) continue;
            ScimResource scimResource = bulkOperation.getData();
            String scimResourceBaseUrn = scimResource.getBaseUrn();
            Schema schema = this.registry.getSchema(scimResourceBaseUrn);
            List attributes = schema.getAttributes();
            BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, bulkId, scimResource, attributes);
        }
        return reverseDependenciesGraph;
    }

    private static class UnresolvedTopLevelComplex
    extends UnresolvedTopLevel {
        public final Object complex;
        public final List<UnresolvedComplex> unresolveds;

        public UnresolvedTopLevelComplex(Field field, Object complex, List<UnresolvedComplex> unresolveds) {
            super(field);
            this.complex = complex;
            this.unresolveds = unresolveds;
        }

        @Override
        public void resolve(ScimResource scimResource, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            try {
                for (UnresolvedComplex unresolved : this.unresolveds) {
                    unresolved.resolve(bulkIdKeyToOperationResult);
                }
                this.field.set(scimResource, this.complex);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Could not resolve top level SCIM resource", (Throwable)illegalAccessException);
            }
        }
    }

    private static class UnresolvedTopLevelBulkId
    extends UnresolvedTopLevel {
        private final String unresolvedBulkIdKey;

        public UnresolvedTopLevelBulkId(Field field, String bulkIdKey) {
            super(field);
            this.unresolvedBulkIdKey = bulkIdKey;
        }

        @Override
        public void resolve(ScimResource scimResource, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(this.unresolvedBulkIdKey);
            BaseResource response = resolvedOperationResult.getResponse();
            ScimResource resolvedResource = resolvedOperationResult.getData();
            if (!(response != null && response instanceof ErrorResponse || resolvedResource == null)) {
                String resolvedId = resolvedResource.getId();
                try {
                    this.field.set(scimResource, resolvedId);
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.error("Failed to access bulkId field", (Throwable)illegalAccessException);
                }
            } else {
                throw new UnresolvableOperationException("Bulk ID cannot be resolved because the resource it refers to had failed to be created: " + this.unresolvedBulkIdKey);
            }
        }
    }

    private static abstract class UnresolvedTopLevel {
        protected final Field field;

        public abstract void resolve(ScimResource var1, Map<String, BulkOperation> var2) throws UnresolvableOperationException;

        @ConstructorProperties(value={"field"})
        public UnresolvedTopLevel(Field field) {
            this.field = field;
        }
    }

    private static class UnresolvedComplex {
        private final Object object;
        private final Field field;
        private final String bulkIdKey;

        public void resolve(Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            BulkOperation resolvedOperation = bulkIdKeyToOperationResult.get(this.bulkIdKey);
            BaseResource response = resolvedOperation.getResponse();
            ScimResource resolvedResource = resolvedOperation.getData();
            if (!(response != null && response instanceof ErrorResponse || resolvedResource == null)) {
                String resolvedId = resolvedResource.getId();
                try {
                    this.field.set(this.object, resolvedId);
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.error("Failed to access bulkId field", (Throwable)illegalAccessException);
                }
            } else {
                throw new UnresolvableOperationException(String.format(BulkResourceImpl.BULK_ID_REFERS_TO_FAILED_RESOURCE, this.bulkIdKey));
            }
        }

        @ConstructorProperties(value={"object", "field", "bulkIdKey"})
        public UnresolvedComplex(Object object, Field field, String bulkIdKey) {
            this.object = object;
            this.field = field;
            this.bulkIdKey = bulkIdKey;
        }
    }

    private static class UnresolvableOperationException
    extends Exception {
        private static final long serialVersionUID = -6081994707016671935L;

        public UnresolvableOperationException(String message) {
            super(message);
        }
    }

    private static class IWishJavaHadTuples {
        public final String bulkIdKey;
        public final List<UnresolvedTopLevel> unresolveds;
        public final BulkOperation bulkOperationResult;

        @ConstructorProperties(value={"bulkIdKey", "unresolveds", "bulkOperationResult"})
        public IWishJavaHadTuples(String bulkIdKey, List<UnresolvedTopLevel> unresolveds, BulkOperation bulkOperationResult) {
            this.bulkIdKey = bulkIdKey;
            this.unresolveds = unresolveds;
            this.bulkOperationResult = bulkOperationResult;
        }
    }
}

