/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LDAPBackupResponse
extends LDAPExtendedResponse {
    private int bufferLength;
    private String stateInfo;
    private String chunkSizesString;
    private byte[] returnedBuffer;

    public LDAPBackupResponse(RfcLDAPMessage rfcMessage) throws IOException {
        super(rfcMessage);
        int modificationTime = 0;
        int revision = 0;
        int chunksSize = 0;
        int[] chunks = null;
        if (this.getID() == null || !this.getID().equals("2.16.840.1.113719.1.27.100.97")) {
            throw new IOException("LDAP Extended Operation not supported");
        }
        if (this.getResultCode() == 0) {
            int i;
            byte[] returnedValue = this.getValue();
            if (returnedValue == null) {
                throw new IOException("LDAP Operations error. No returned value.");
            }
            LBERDecoder decoder = new LBERDecoder();
            if (decoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream currentPtr = new ByteArrayInputStream(returnedValue);
            ASN1Integer asn1_bufferLength = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_bufferLength == null) {
                throw new IOException("Decoding error");
            }
            this.bufferLength = asn1_bufferLength.intValue();
            ASN1Integer asn1_modificationTime = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_modificationTime == null) {
                throw new IOException("Decoding error");
            }
            modificationTime = asn1_modificationTime.intValue();
            ASN1Integer asn1_revision = (ASN1Integer)decoder.decode(currentPtr);
            if (asn1_revision == null) {
                throw new IOException("Decoding error");
            }
            revision = asn1_revision.intValue();
            this.stateInfo = modificationTime + "+" + revision;
            ASN1OctetString asn1_returnedBuffer = (ASN1OctetString)decoder.decode(currentPtr);
            if (asn1_returnedBuffer == null) {
                throw new IOException("Decoding error");
            }
            this.returnedBuffer = asn1_returnedBuffer.byteValue();
            ASN1Sequence asn1_chunksSeq = (ASN1Sequence)decoder.decode(currentPtr);
            if (asn1_chunksSeq == null) {
                throw new IOException("Decoding error");
            }
            chunksSize = ((ASN1Integer)asn1_chunksSeq.get(0)).intValue();
            chunks = new int[chunksSize];
            ASN1Set asn1_chunksSet = (ASN1Set)asn1_chunksSeq.get(1);
            for (int index = 0; index < chunksSize; ++index) {
                ASN1Sequence asn1_eachSeq = (ASN1Sequence)asn1_chunksSet.get(index);
                chunks[index] = ((ASN1Integer)asn1_eachSeq.get(0)).intValue();
            }
            StringBuffer tempBuffer = new StringBuffer();
            tempBuffer.append(chunksSize);
            tempBuffer.append(";");
            for (i = 0; i < chunksSize - 1; ++i) {
                tempBuffer.append(chunks[i]);
                tempBuffer.append(";");
            }
            tempBuffer.append(chunks[i]);
            this.chunkSizesString = tempBuffer.toString();
        } else {
            this.bufferLength = 0;
            this.stateInfo = null;
            this.chunkSizesString = null;
            this.returnedBuffer = null;
        }
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public String getStatusInfo() {
        return this.stateInfo;
    }

    public String getChunkSizesString() {
        return this.chunkSizesString;
    }

    public byte[] getReturnedBuffer() {
        return this.returnedBuffer;
    }
}

