/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.FullGcNodeBin;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoFullGcNodeBin
implements FullGcNodeBin {
    public static final String GC_COLLECTED_AT = "_gcCollectedAt";
    private static final Logger LOG = LoggerFactory.getLogger(MongoFullGcNodeBin.class);
    private final MongoDocumentStore mongoDocumentStore;
    private boolean enabled;

    public MongoFullGcNodeBin(MongoDocumentStore ds) {
        this(ds, false);
    }

    public MongoFullGcNodeBin(MongoDocumentStore store, boolean fullGcBinEnabled) {
        this.mongoDocumentStore = store;
        this.enabled = fullGcBinEnabled;
    }

    @Override
    public int remove(Map<String, Long> orphanOrDeletedRemovalMap) {
        if (orphanOrDeletedRemovalMap.isEmpty() || !this.addToBin(orphanOrDeletedRemovalMap)) {
            return 0;
        }
        return this.mongoDocumentStore.remove(Collection.NODES, orphanOrDeletedRemovalMap);
    }

    @Override
    public List<NodeDocument> findAndUpdate(List<UpdateOp> updateOpList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating {} documents", (Object)updateOpList.size());
        }
        if (updateOpList.isEmpty() || !this.addToBin(updateOpList)) {
            return Collections.emptyList();
        }
        return this.mongoDocumentStore.findAndUpdate(Collection.NODES, updateOpList);
    }

    private boolean addToBin(Map<String, Long> orphanOrDeletedRemovalMap) {
        if (!this.enabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bin is disabled, skipping adding delete candidate documents to bin");
            }
            return true;
        }
        LOG.info("Adding {} delete candidate documents to bin", (Object)orphanOrDeletedRemovalMap.size());
        List<BasicDBObject> docs = orphanOrDeletedRemovalMap.keySet().stream().map(e -> new UpdateOp((String)e, true)).map(this::toBasicDBObject).collect(Collectors.toList());
        try {
            return this.persist(docs);
        }
        catch (Exception e2) {
            LOG.error("Error while adding delete candidate documents to bin: {}", docs, (Object)e2);
            return false;
        }
    }

    private boolean addToBin(List<UpdateOp> updateOpList) {
        if (!this.enabled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bin is disabled, skipping adding removed properties to bin");
            }
            return true;
        }
        LOG.info("Adding {} removed properties to bin", (Object)updateOpList.size());
        List<BasicDBObject> binOpList = updateOpList.stream().map(this::toBasicDBObject).collect(Collectors.toList());
        try {
            return this.persist(binOpList);
        }
        catch (Exception e) {
            LOG.error("Error while adding removed properties to bin: {}", binOpList, (Object)e);
            return false;
        }
    }

    private boolean persist(List<BasicDBObject> inserts) {
        this.mongoDocumentStore.getBinCollection().insertMany(inserts);
        return true;
    }

    private BasicDBObject toBasicDBObject(UpdateOp op) {
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"_id", (Object)("/bin/" + op.getId() + "-" + Instant.now().toEpochMilli()));
        op.getChanges().forEach((k, v) -> {
            if (v.type == UpdateOp.Operation.Type.REMOVE) {
                doc.put((Object)k.getName(), (Object)"");
            }
        });
        doc.put((Object)GC_COLLECTED_AT, (Object)new Date());
        return doc;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        LOG.info("Full GC Bin changed to {}", (Object)(this.enabled ? "enabled" : "disabled"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    MongoDocumentStore getMongoDocumentStore() {
        return this.mongoDocumentStore;
    }
}

