/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.Precision;
import org.apache.jackrabbit.guava.common.util.concurrent.AtomicDouble;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStoreThrottlingMetricsUpdater
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStoreThrottlingMetricsUpdater.class);
    static final String TS_TIME = "ts";
    private static final String NATURAL = "$natural";
    private static final String MAX_SIZE = "maxSize";
    private static final String OPLOG_RS = "oplog.rs";
    public static final String SIZE = "size";
    private final ScheduledExecutorService throttlingMetricsExecutor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicDouble oplogWindow;
    private final MongoDatabase localDb;

    public MongoDocumentStoreThrottlingMetricsUpdater(@NotNull MongoDatabase localDb, @NotNull AtomicDouble oplogWindow) {
        this.oplogWindow = oplogWindow;
        this.localDb = localDb;
    }

    public void scheduleUpdateMetrics() {
        this.throttlingMetricsExecutor.scheduleAtFixedRate(() -> {
            Document document = this.localDb.runCommand((Bson)new Document("collStats", (Object)OPLOG_RS));
            if (!document.containsKey((Object)MAX_SIZE) || !document.containsKey((Object)SIZE)) {
                LOG.warn("Could not get stats for local.{}  collection. collstats returned: {}.", (Object)OPLOG_RS, (Object)document);
                this.oplogWindow.set(2.147483647E9);
            } else {
                int maxSize = document.getInteger((Object)MAX_SIZE);
                double maxSizeGb = (double)maxSize / 1.073741824E9;
                int usedSize = document.getInteger((Object)SIZE);
                double usedSizeGb = Math.ceil((double)usedSize / 1.073741824E9 * 1000000.0) / 1000000.0;
                MongoCollection localDbCollection = this.localDb.getCollection(OPLOG_RS);
                Document first = (Document)localDbCollection.find().sort((Bson)new Document(NATURAL, (Object)1)).limit(1).first();
                Document last = (Document)localDbCollection.find().sort((Bson)new Document(NATURAL, (Object)-1)).limit(1).first();
                if (Objects.isNull(first) || Objects.isNull(last)) {
                    LOG.warn("Objects not found in local.oplog.rs -- is this a new and empty db instance?");
                    this.oplogWindow.set(2.147483647E9);
                } else if (!first.containsKey((Object)TS_TIME) || !last.containsKey((Object)TS_TIME)) {
                    LOG.warn("ts element not found in oplog objects");
                    this.oplogWindow.set(2.147483647E9);
                } else {
                    this.oplogWindow.set(MongoDocumentStoreThrottlingMetricsUpdater.updateOplogWindow(maxSizeGb, usedSizeGb, first, last));
                }
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }

    static double updateOplogWindow(double maxSize, double usedSize, @NotNull Document first, @NotNull Document last) {
        BsonTimestamp lastTime;
        BsonTimestamp startTime = (BsonTimestamp)first.get((Object)TS_TIME, BsonTimestamp.class);
        if (Objects.equals(startTime, lastTime = (BsonTimestamp)last.get((Object)TS_TIME, BsonTimestamp.class)) || Precision.equals((double)usedSize, (double)0.0, (double)1.0E-5)) {
            return 2.147483647E9;
        }
        long timeDiffSec = Math.abs(lastTime.getTime() - startTime.getTime());
        double timeDiffHr = Math.ceil((double)timeDiffSec / 3600.0 * 100000.0) / 100000.0;
        double currentOplogHourRate = usedSize / timeDiffHr;
        double timeLeft = maxSize / currentOplogHourRate;
        LOG.info("Replication info: Oplog Max Size {} Gb, Used Oplog Size {} Gb, First Oplog Entry {}, Last Oplog Entry {}, Oplog Entries Time Diff {} sec, Oplog-Gb/hour rate {}, time left {}", new Object[]{maxSize, usedSize, startTime.getTime(), lastTime.getTime(), timeDiffSec, currentOplogHourRate, timeLeft});
        return timeLeft;
    }

    @Override
    public void close() throws IOException {
        new ExecutorCloser((ExecutorService)this.throttlingMetricsExecutor).close();
    }
}

