/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import java.io.Closeable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.hash.BloomFilter;
import org.apache.jackrabbit.guava.common.hash.Funnel;
import org.apache.jackrabbit.guava.common.hash.PrimitiveSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheChangesTracker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheChangesTracker.class);
    static final int ENTRIES_SCOPED = 1000;
    static final int ENTRIES_OPEN = 10000;
    private final List<CacheChangesTracker> changeTrackers;
    private final Predicate<String> keyFilter;
    private final LazyBloomFilter lazyBloomFilter;

    CacheChangesTracker(Predicate<String> keyFilter, List<CacheChangesTracker> changeTrackers, int bloomFilterSize) {
        this.changeTrackers = changeTrackers;
        this.keyFilter = keyFilter;
        this.lazyBloomFilter = new LazyBloomFilter(bloomFilterSize);
        changeTrackers.add(this);
    }

    public void invalidateDocument(String key) {
        if (this.keyFilter.test(key)) {
            this.lazyBloomFilter.put(key);
        }
    }

    public boolean mightBeenAffected(String key) {
        return this.keyFilter.test(key) && this.lazyBloomFilter.mightContain(key);
    }

    @Override
    public void close() {
        this.changeTrackers.remove(this);
        if (LOG.isDebugEnabled()) {
            if (this.lazyBloomFilter.filter == null) {
                LOG.debug("Disposing CacheChangesTracker for {}, no filter was needed", this.keyFilter);
            } else {
                LOG.debug("Disposing CacheChangesTracker for {}, filter fpp was: {}", this.keyFilter, (Object)this.lazyBloomFilter.filter.expectedFpp());
            }
        }
    }

    public static class LazyBloomFilter {
        private static final double FPP = 0.01;
        private final int entries;
        private volatile BloomFilter<String> filter;

        public LazyBloomFilter(int entries) {
            this.entries = entries;
        }

        public synchronized void put(String entry) {
            this.getFilter().put((Object)entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean mightContain(String entry) {
            if (this.filter == null) {
                return false;
            }
            LazyBloomFilter lazyBloomFilter = this;
            synchronized (lazyBloomFilter) {
                return this.filter.mightContain((Object)entry);
            }
        }

        private BloomFilter<String> getFilter() {
            if (this.filter == null) {
                this.filter = BloomFilter.create((Funnel)new Funnel<String>(){
                    private static final long serialVersionUID = -7114267990225941161L;

                    public void funnel(String from, PrimitiveSink into) {
                        into.putUnencodedChars((CharSequence)from);
                    }
                }, (int)this.entries, (double)0.01);
            }
            return this.filter;
        }
    }
}

