/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class PrefetchDispatcher
extends ChangeDispatcher {
    private final Executor executor;
    private NodeState root;

    public PrefetchDispatcher(@NotNull NodeState root, @NotNull Executor executor) {
        super(root);
        this.root = root;
        this.executor = Objects.requireNonNull(executor);
    }

    public synchronized void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        DocumentNodeState state;
        if (root instanceof DocumentNodeState && (state = (DocumentNodeState)root).isFromExternalChange()) {
            this.executor.execute(new Runnable(){
                private final NodeState before;
                {
                    this.before = PrefetchDispatcher.this.root;
                }

                @Override
                public void run() {
                    EditorDiff.process((Editor)new VisibleEditor(TraversingEditor.INSTANCE), (NodeState)this.before, (NodeState)state);
                }
            });
        }
        super.contentChanged(root, info);
        this.root = root;
    }

    private static final class TraversingEditor
    extends DefaultEditor {
        static final Editor INSTANCE = new TraversingEditor();

        private TraversingEditor() {
        }

        public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
            return this;
        }

        public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            return this;
        }

        public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            return this;
        }
    }
}

