/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service.model.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;

@Entity
@Table(name="sc_scheduleevent_contributor")
public class Contributor
implements Comparable<Contributor>,
Serializable {
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="scheduleeventid", nullable=false)
    private ScheduleEvent scheduleEvent;
    private int userId;
    @Transient
    private String userName;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastVisit;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastValidation;

    @PrePersist
    protected void setUpId() {
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public int compareTo(Contributor o) {
        if (this.getUserId() == o.getUserId()) {
            return 0;
        }
        if (this.getUserName() != null && !this.getUserName().equals(o.getUserName())) {
            return this.getUserName().compareTo(o.getUserName());
        }
        return 1;
    }

    public void setLastVisit(Date lastVisit) {
        this.lastVisit = lastVisit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Contributor other = (Contributor)obj;
        if (this.id == null) {
            if (other.id != null) {
                return false;
            }
            return this.userId == other.userId;
        }
        return this.id.equals(other.id);
    }

    public Date getLastVisit() {
        return this.lastVisit;
    }

    public Date getLastValidation() {
        return this.lastValidation;
    }

    public void setLastValidation(Date lastValidation) {
        this.lastValidation = lastValidation;
    }

    public void setScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEvent = scheduleEvent;
    }

    public ScheduleEvent getScheduleEvent() {
        return this.scheduleEvent;
    }
}

