/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.variables;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.owasp.encoder.Encode;
import org.silverpeas.core.annotation.constraint.DateRange;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.variables.Variable;
import org.silverpeas.core.variables.VariableScheduledValueRepository;
import org.silverpeas.core.variables.VariablesRepository;

@Entity
@Table(name="sb_variables_value")
@DateRange(start="startDate", end="endDate")
public class VariableScheduledValue
extends SilverpeasJpaEntity<VariableScheduledValue, UuidIdentifier> {
    @Column(nullable=false)
    private String value;
    @Column(columnDefinition="DATE", nullable=false)
    private LocalDate startDate;
    @Column(columnDefinition="DATE", nullable=false)
    private LocalDate endDate;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="variableId", referencedColumnName="id", nullable=false)
    private Variable variable;

    protected VariableScheduledValue() {
    }

    public VariableScheduledValue(String value, Period period) {
        this.value = value;
        this.startDate = TemporalConverter.asLocalDate(period.getStartDate());
        this.endDate = TemporalConverter.asLocalDate(period.getEndDate());
    }

    public static List<VariableScheduledValue> getCurrentOnes() {
        return VariablesRepository.get().getAllCurrentVariables().stream().map(v -> v.getVariableValues().getCurrent()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Period getPeriod() {
        return Period.between(this.startDate, this.endDate);
    }

    public String getValue() {
        return this.value;
    }

    void setVariable(Variable value) {
        this.variable = value;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public String getValueForHTML() {
        return Encode.forHtml((String)this.getValue());
    }

    public void merge(VariableScheduledValue value) {
        this.value = value.getValue();
        this.startDate = TemporalConverter.asLocalDate(value.getPeriod().getStartDate());
        this.endDate = TemporalConverter.asLocalDate(value.getPeriod().getEndDate());
    }

    public VariableScheduledValue updateFrom(VariableScheduledValue newValue) {
        return Transaction.performInOne(() -> {
            this.merge(newValue);
            return VariableScheduledValueRepository.get().save(this);
        });
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

