/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasListWrapper;

public interface SilverpeasList<T>
extends List<T> {
    public static <C, R extends SilverpeasList<C>> Collector<C, R, R> collector(List<?> source) {
        Supplier<SilverpeasList> supplier = source instanceof SilverpeasList && ((SilverpeasList)source).isSlice() ? () -> ((SilverpeasList)source).newEmptyListWithSameProperties() : () -> new SilverpeasArrayList();
        BiConsumer<SilverpeasList, Object> consumer = List::add;
        BinaryOperator operator = (left, right) -> {
            left.addAll(right);
            return left;
        };
        return Collector.of(supplier, consumer, operator, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <T> SilverpeasList<T> as(T[] arrayToConvert) {
        SilverpeasArrayList list = new SilverpeasArrayList(arrayToConvert.length);
        list.addAll(Arrays.asList(arrayToConvert));
        return list;
    }

    public static <T> SilverpeasList<T> wrap(List<T> listToWrap) {
        return listToWrap instanceof SilverpeasList ? (SilverpeasList<T>)listToWrap : new SilverpeasListWrapper<T>(listToWrap);
    }

    public <U> SilverpeasList<U> newEmptyListWithSameProperties();

    public long originalListSize();

    default public boolean isSlice() {
        return this.originalListSize() != (long)this.size();
    }
}

