/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.scheduler.trigger;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import org.silverpeas.core.scheduler.trigger.CronExpression;
import org.silverpeas.core.scheduler.trigger.CronExpressionFactory;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.JobTriggerVisitor;
import org.silverpeas.core.util.ServiceProvider;

public final class CronJobTrigger
extends JobTrigger {
    private CronExpression cron;

    public CronExpression getCronExpression() {
        return this.cron;
    }

    protected CronJobTrigger(String cronExpression) throws ParseException {
        String[] cronExpressionParts = cronExpression.trim().split("[ ]+");
        if (cronExpressionParts.length != 5) {
            throw new ParseException("Malformed cron expression '" + cronExpression + "'. The cron expression must contain 5 space-separated statements: MINUTES HOURS DAY_OF_MONTH MONTH DAY_OF_WEEK", cronExpression.length());
        }
        if (cronExpressionParts[2].equals("*") && cronExpressionParts[4].matches("[0-9,/\\-,\\*]+")) {
            cronExpressionParts[2] = "?";
        } else if (cronExpressionParts[4].equals("*") && cronExpressionParts[2].matches("[0-9,/\\-]+")) {
            cronExpressionParts[4] = "?";
        }
        CronExpressionFactory factory = ServiceProvider.getService(CronExpressionFactory.class, new Annotation[0]);
        this.cron = factory.create(cronExpressionParts[0] + " " + cronExpressionParts[1] + " " + cronExpressionParts[2] + " " + cronExpressionParts[3] + " " + cronExpressionParts[4]);
    }

    @Override
    public void accept(JobTriggerVisitor visitor) {
        visitor.visit(this);
    }
}

