/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@DiscriminatorValue(value="datetime")
public class DateTimeReminder
extends Reminder {
    private static final long serialVersionUID = 472505709526636072L;
    @Transient
    private transient OffsetDateTime dateTime;

    @Override
    public Reminder copy() {
        DateTimeReminder copy = (DateTimeReminder)super.copy();
        copy.dateTime = this.dateTime;
        return copy;
    }

    public DateTimeReminder(ContributionIdentifier contributionId, ReminderProcessName processName) {
        super(contributionId, processName);
    }

    public DateTimeReminder(ContributionIdentifier contributionId, User user, ReminderProcessName processName) {
        super(contributionId, user, processName);
    }

    protected DateTimeReminder() {
    }

    public final DateTimeReminder withText(String text) {
        return (DateTimeReminder)super.withText(text);
    }

    public DateTimeReminder triggerAt(OffsetDateTime dateTime) {
        ZoneId userZoneId = this.getUserZoneId();
        this.dateTime = dateTime.atZoneSameInstant(userZoneId).toOffsetDateTime();
        return this;
    }

    public DateTimeReminder triggerFrom(String temporalProperty) {
        return (DateTimeReminder)this.withContributionProperty(temporalProperty);
    }

    public OffsetDateTime getDateTime() {
        return this.isScheduled() ? this.getScheduledDateTime() : this.dateTime;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected OffsetDateTime computeTriggeringDate() {
        OffsetDateTime computedDate = super.computeTriggeringDate();
        if (computedDate == null && StringUtil.isDefined((String)this.getContributionProperty())) {
            ContributionModel model = this.getContribution().getModel();
            ZoneId userZoneId = this.getUserZoneId();
            OffsetDateTime propertyDateTime = this.applyFilterOnTemporalType(model.filterByType(this.getContributionProperty(), new Object[0]), userZoneId);
            computedDate = !propertyDateTime.isBefore(OffsetDateTime.now()) ? propertyDateTime : null;
        } else {
            computedDate = this.dateTime;
        }
        return computedDate;
    }
}

