/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.identifier;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Embeddable
public class UniqueLongIdentifier
implements EntityIdentifier {
    private static final long serialVersionUID = 8570844400186460258L;
    @Column(name="id", nullable=false)
    private Long id;

    public static UniqueLongIdentifier from(String value) {
        return new UniqueLongIdentifier().fromString(value);
    }

    public static UniqueLongIdentifier from(long value) {
        return new UniqueLongIdentifier().setId(value);
    }

    public static List<UniqueLongIdentifier> fromLongs(Collection<Long> values) {
        return values.stream().map(UniqueLongIdentifier::from).collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    private UniqueLongIdentifier setId(Long id) {
        this.id = id;
        return this;
    }

    @Override
    public String asString() {
        return this.getId().toString();
    }

    @Override
    public UniqueLongIdentifier fromString(String id) {
        return this.setId(Long.valueOf(id));
    }

    @Override
    public UniqueLongIdentifier generateNewId(String ... parameters) {
        String tableName = parameters[0];
        String tableColumnIdName = parameters[1];
        this.id = DBUtil.getNextId(tableName, tableColumnIdName);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueLongIdentifier other = (UniqueLongIdentifier)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public String toString() {
        return this.asString();
    }
}

