/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.system;

import java.lang.annotation.Annotation;
import javax.annotation.Resource;
import javax.inject.Singleton;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class JMSOperation {
    @Resource
    private ConnectionFactory jmsConnectionFactory;

    private static JMSOperation get() {
        return ServiceProvider.getService(JMSOperation.class, new Annotation[0]);
    }

    private JMSOperation() {
    }

    public static void realize(Operation operation) {
        JMSOperation.get().doRealize(operation);
    }

    private void doRealize(Operation operation) {
        try (JMSContext context = this.jmsConnectionFactory.createContext();){
            try {
                operation.realize(context);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface Operation {
        public void realize(JMSContext var1) throws Exception;
    }
}

